/*  DS
 *  Copyright (C) Anders Asplund and Joakim Kolsjö 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#include "handler.h"

using namespace std;

namespace DS
{	
	TimeRange::TimeRange()
	{
		m_active = false;
	}
	
	void TimeRange::SetRange(long start, long end)
	{
		m_start = start;
		m_end = end;
	}
	
	bool TimeRange::IsActive(long time)
	{
		if(time >= m_start && time <= m_end)
			return true;
		else
			return false;
	}

	Handler::Handler()
	{
		m_pHandleAttr = new Map;
		m_pDefaultNodeAttr = new Map;
		m_pDataReader = 0;
		m_pTextureLoader = 0;
		m_pModelLoader = 0;
	}
	
	Handler::~Handler()
	{
		delete m_pHandleAttr;
		delete m_pDefaultNodeAttr;
		
		for(int i = 0; i < (int)m_NodeAttrList.size(); i++)
			delete m_NodeAttrList[i];
		
		m_NodeAttrList.clear();	
	}

	void Handler::SetupRange()
	{
		SetRange(atol(m_NodeAttrList[0]->Get("time")), 
			atol(m_NodeAttrList[m_NodeAttrList.size()-1]->Get("time")));
	}
	
	void Handler::SetResources(DataReader* pDataReader,
		TextureLoader* pTextureLoader, ModelLoader* pModelLoader)
	{
		m_pDataReader = pDataReader;
		m_pTextureLoader = pTextureLoader;
		m_pModelLoader = pModelLoader;
	}
	
	Map* Handler::GetHandlerAttr()
	{
		return m_pHandleAttr;
	}
	
	Map* Handler::CreateNodeAttr()
	{
		Map* pNewNode = m_pDefaultNodeAttr->Clone();
		m_NodeAttrList.push_back(pNewNode);
		return pNewNode;
	}
}
