/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */
 
#ifndef DS_H
#define DS_H

#include "common.h"
#include "loadinfo.h"
#include "io/music.h"
#include "launcher.h"
#include "scriptparser.h"
#include "io/datareader.h"
#include "io/modelloader.h"
#include "io/textureloader.h"
#include "io/loaders/read_xpk.h"
#include "io/loaders/read_file.h"

namespace DS
{	
	class DemoSystem : public ScriptParser {
	public:
		~DemoSystem();
		static DemoSystem* Instance(int argc, char** argv, const char* pDataSource, const char* pScript);
		static void Release();
		void Run();
	protected:
		DemoSystem(int argc, char** argv, const char* pDataSource, const char* pScript);
		bool m_bLoadingActive;
		LoadInfo* m_pLoadInfo;
	private:
		void PlayScenes();
		static int CacheThread(void* pData);
		void LoadData();	
		void RenderLoadstate();	
	
		int m_repeat;
		char **m_argv;
		int m_argc;
	
		Video* m_pVideo;
		TextureLoader* m_pTextureLoader;
		ModelLoader* m_pModelLoader;
		Music* m_pMusic;
		SDL_Thread* m_pCacheThread;

		LauncherConfig m_config;
		static DemoSystem* m_pInstance;
	};
}

#endif
