/*
  LandScap.c 
  Creacin y visualizacin de un LandsCape de 256x200.
  Coded by [NoP] of Compiler SoftWare.
  
  Aviso que no est nada optimizado para facilitar su lectura... :)
  Adems he intentado no poner ASM para aquellos que no tenga tasm.
 */

#include <conio.h>
#include <dos.h>
#include <stdlib.h>
#include <alloc.h>
#include <time.h>

void SetVideoMode( char );
void PutPixel( int, int, char );
void SetPalette( unsigned char * );

char CalcAverage( int, int, int );
void Plasma( int, int, int, int, unsigned char * );
void RotatePalette ( unsigned char * );
void RotatePlasmaPalette ( void );
void BlurringFilter( void );

unsigned char *Mapa;

/* File created with  BIN2TXT  v1.0  by  NOP of Compiler SoftWare */
unsigned char LandScapePalette[ 768 ] = { 
      0,0,0,0,0,25,0,0,25,0,0,26,0,0,27,0,0,28,0,0,
      28,0,0,29,0,0,30,0,0,31,0,0,32,0,0,32,0,0,33,0,
      0,34,0,0,35,0,0,36,0,0,36,0,0,37,0,0,38,0,0,39,
      0,0,39,0,0,40,0,0,41,0,0,42,0,0,43,0,0,43,0,0,
      44,0,0,45,0,0,46,0,0,47,0,0,47,0,0,48,0,0,49,0,
      0,50,0,0,51,0,0,51,0,0,52,0,0,53,0,0,54,0,0,54,
      0,0,55,0,0,56,0,0,57,0,0,58,0,0,58,0,0,59,0,0,
      60,0,0,61,0,0,62,4,4,63,7,7,63,11,11,63,15,15,63,18,
      18,63,22,22,63,26,26,63,29,29,63,33,33,63,37,37,63,40,40,63,
      44,44,63,48,48,63,51,51,63,55,55,63,59,59,63,50,50,0,46,50,
      0,43,51,0,40,52,0,37,53,0,34,54,0,31,54,0,28,55,0,25,
      56,0,21,57,0,18,58,0,15,58,0,12,59,0,9,60,0,6,61,0,
      3,62,0,0,63,0,0,62,0,1,62,0,1,61,0,2,61,0,2,60,
      0,3,60,0,3,59,0,4,59,0,4,58,0,5,58,0,5,57,0,6,
      57,0,6,56,0,7,56,0,7,55,0,8,55,0,8,54,0,9,54,0,
      9,53,0,10,53,0,10,52,0,11,52,0,11,51,0,12,51,0,12,50,
      0,13,50,0,13,49,0,14,49,0,14,48,0,15,48,0,15,47,0,16,
      47,0,16,46,0,17,46,0,17,45,0,18,45,0,18,44,0,19,44,0,
      19,43,0,20,43,0,20,42,0,21,42,0,21,41,0,22,41,0,22,40,
      0,23,40,0,23,39,0,24,39,0,24,38,0,25,38,0,25,37,0,26,
      37,0,26,36,0,27,36,0,27,35,0,28,35,0,28,34,0,29,34,0,
      29,33,0,30,33,0,30,32,0,31,32,0,31,31,0,31,31,0,31,31,
      1,32,32,2,32,32,3,33,33,4,33,33,5,34,34,6,34,34,7,35,
      35,8,35,35,9,36,36,10,36,36,11,37,37,12,37,37,13,38,38,14,
      38,38,15,39,39,16,39,39,17,40,40,18,40,40,19,41,41,20,41,41,
      21,42,42,22,42,42,23,43,43,24,43,43,25,44,44,26,44,44,27,45,
      45,28,45,45,29,46,46,30,46,46,31,47,47,32,47,47,33,48,48,34,
      48,48,35,49,49,36,49,49,37,50,50,38,50,50,39,51,51,40,51,51,
      41,52,52,42,52,52,43,53,53,44,53,53,45,54,54,46,54,54,47,0,
      63,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0
 };

/**/
void main()
{
int x, y; 


  Mapa = (unsigned char *) calloc(256*200, 1);         /* asignar memoria */ 

  if ( Mapa == NULL )
   {
    cprintf("\aNo hay suficiente memoria para el buffer de 256*200.\r\n");
    exit(1);
   }
 
 cprintf("Generating 256x200 plasma landscape...");
 randomize();

 Mapa[0] = 128;
 BlurringFilter();
 Plasma( 0, 0, 255, 199, Mapa );
 
 SetVideoMode(0x13);
 SetPalette( LandScapePalette );

 for( y=0; y<200; y++ )
  for( x=0; x<256; x++ )
   PutPixel( x, y, Mapa[(y*256)+x] );
 
 getch();

 SetVideoMode(0x3);
 free(Mapa);                                         /* liberar memoria */

}

/**/
void SetVideoMode( char modo )
{
/* me parece que es la 1 vez que uso esto en vez de asm... X'DDD */
 union REGS regs;

  regs.h.ah = 0;              /* iniciar modo de video */
  regs.h.al = modo;
  int86(0x10, &regs, &regs);

}

/**/
void SetPalette( unsigned char *Paleta )
{
  int contador;

  outportb( 0x3c8, 0 );
    
  for( contador=0; contador<256*3; contador++ )
    outportb( 0x3c9, Paleta[contador] );

}

/**/
void PutPixel( int x, int y, char color )
{
  pokeb(0xA000, (320*y)+x, color );
}

/**/
char CalcAverage( int value, int noise, int elements )
{
   int average;
       average = (value+noise-random(noise*2)) / elements;
       
       if (average>192) average = (average%192)+1; 
       else if (average<5) average = 5;

       return(average);
}

/**/
void Plasma( int x1, int y1, int x2, int y2, unsigned char *Mapa )
{
  int XMedia, YMedia, Valor1, Valor2, Valor3, Valor4, Noise;

    if( (x2-x1)<2 && (y2-y1)<2 ) return;                         /* paso 1 */
    
      XMedia = (x2+x1)/2  ;
      YMedia = (y2+y1)/2  ;                                      /* paso 2 */

      Noise = 5*(x2-x1+y2-y1)/3;                                 /* paso 3 */

      Valor1 = Mapa[ (y1*256) + x1 ];
      Valor2 = Mapa[ (y2*256) + x1 ];
      Valor3 = Mapa[ (y1*256) + x2 ];
      Valor4 = Mapa[ (y2*256) + x2 ];                            /* paso 4 */
            
      if( Mapa[ (y1*256)+ XMedia] == 0 )                         /* paso 5 */
            Mapa[ (y1*256)+ XMedia] = CalcAverage( Valor1+Valor3, Noise, 2 );
      if( Mapa[(YMedia*256)+ x1] == 0 )
            Mapa[(YMedia*256)+ x1] = CalcAverage( Valor1+Valor2, Noise, 2 );
      if( Mapa[(YMedia*256)+ x2] == 0 )
            Mapa[(YMedia*256)+ x2] = CalcAverage( Valor3+Valor4, Noise, 2 );
      if( Mapa[(y2*256)+ XMedia] == 0 )
            Mapa[(y2*256)+ XMedia] = CalcAverage( Valor2+Valor4, Noise, 2 );

      Mapa[(YMedia*256)+XMedia] =                                /* paso 6 */
        CalcAverage( Valor1+Valor2+Valor3+Valor4, Noise, 4 );

      Plasma( x1, y1, XMedia, YMedia, Mapa );                    /* paso 7 */
      Plasma( XMedia, y1, x2, YMedia, Mapa );
      Plasma( x1, YMedia, XMedia, y2, Mapa );
      Plasma( XMedia, YMedia, x2, y2, Mapa );
}
 

/**/
#define  NUM_POINTS    10000
#define  K1             4/10
#define  K2             3/10
#define  K3             3/10                             /* K1+K2+K3 = 1 */

void BlurringFilter( void )
{
      int bucle, x, y;

       for( bucle=0; bucle<NUM_POINTS; bucle++ )
        {
         x = 5+random(250);
         y = 5+random(195);                  /* cogemos puntos aleatorios */
         Mapa[256*y+x] = Mapa[256*y+x]*K1 + 
                         Mapa[256*(y-2)+(x+3)]*K2 + 
                         Mapa[256*(y-4)+(x+2)]*K3;
        }
}
