////////////////////////////
// Definicin clase "Cadena"
//    Navi Dj / PhyMosys
////////////////////////////

#ifndef __CADENA__
#define __CADENA__

#include <iostream.h>
extern "C" {
  #include <string.h>
  #include <stdio.h>
  }

#define LONG_TIPICA  20         //  La longitud mnima que se asigna.
#define MAX_LONG     100        //  Longitud mxima de la cadena.

class Cadena {

 public:   //  Estos 2 ops. sobrecargados los explicaremos ms adelante.
   friend ostream &operator << (ostream &out, const Cadena &str);
   friend istream &operator >> (istream &in, Cadena &str);
        //  Manipulacin de cadenas
   void    anyade(const Cadena &str);
   void    anyade(const char *str);
   void    compo(const char *str, const char *str2);
   void    compo(const Cadena &str, const char *str2);
   void    compo(const Cadena &str, const Cadena &str2);
   void    compo(const char *str, const Cadena &str2);
   void    copia(const Cadena &str);
   void    copia(const char *str);
   char	   letra(int index);
   Cadena  palabra(int index);
   int	   num_letras(void);
   int	   num_palabras(void);
        //  Comparaciones
   int     igual(const Cadena &str);
   int     igual(const char *str);
   int 	   diferentes(const Cadena &str);
   int     diferentes(const char *str);
   int     anterior(const Cadena &str);
   int     anterior(const char *str);
   int     posterior(const Cadena &str);
   int     posterior(const char *str);
   inline  int maslarga(const Cadena &str) {
	      return longi>str.longi; }
   inline  int maslarga(const char *str) {
	      return longi>strlen(str); }
	//  Busqueda
   int	   donde(const Cadena &str);
   int	   donde(const char *str);
        //  Dominio de la clase
   inline  void reset(void) { _error=0; }
   inline  int error(void) { return _error; }
        //  Constructores
	   Cadena(void);
	   Cadena(const Cadena &cad);
	   Cadena(const char *str);
           Cadena(const char *str, const char *str2);
	   Cadena(const Cadena &str, const Cadena &str2);
	  ~Cadena();

 protected:
   char *contenido;
   int  longi;
   int  _error;
 };

#endif
