///////////////////////////////////////
// Implementacin de la classe "Cadena"
//   Navi Dj / PhyMosys
///////////////////////////////////////

#include "cadena.hpp"

//  Constructor: inicializa las variables.
Cadena :: Cadena(void)
{
 longi=5;
 reset();
 if(!(contenido=new char[LONG_TIPICA]))
   _error=2;
 strcpy(contenido, "Vacio");    //  El texto se puede cambiar.
 }

//  Constructor 2: Otro ms...
Cadena :: Cadena(const Cadena &cad)
{
 reset();
 longi=strlen(cad.contenido);
 if(!(contenido=new char[longi+1]))
   _error=2;
 strcpy(contenido, cad.contenido);
 }

//  Constructor 3: inicializa con ms precisin las variables.
Cadena :: Cadena(const char *str)
{
 reset();
 longi=strlen(str);
 if(!(contenido=new char[longi+1]))
   _error=2;
 strcpy(contenido, str);
 }

//  Constructor 4: inicializa concatenando 2 arrays de caracteres.
Cadena :: Cadena(const char *str, const char *str2)
{
 reset();
 longi=strlen(str)+strlen(str2);
 if(!(contenido=new char[longi+1]))
   _error=2;
 strcpy(contenido, str);
 strcat(contenido, str2);
 }

//  Constructor 5: inicializa concatenando 2 cadenas.
Cadena :: Cadena(const Cadena &str, const Cadena &str2)
{
 reset();
 longi=strlen(str.contenido)+strlen(str2.contenido);
 if(!(contenido=new char[longi+1]))
   _error=2;
 strcpy(contenido, str.contenido);
 strcat(contenido, str2.contenido);
 }

//  Destructor: devuelve la memoria al sistema.
Cadena :: ~Cadena()
{
 delete contenido;
 }

//  Anyade: concatena dos cadenas.
void Cadena :: anyade(const Cadena &str)
{
 char *Cad;
 if(!(Cad=new char[strlen(this->contenido)+strlen(str.contenido)+1]))
   _error=2;
 strcpy(Cad, this->contenido);
 strcat(Cad, str.contenido);
 delete this->contenido;
 longi=strlen(Cad);
 if(!(contenido=new char[longi+1]))
   _error=2;
 strcpy(this->contenido, Cad);
 delete Cad;
 }

//  Anyade: concatena 2 cadenas directament.
void Cadena :: anyade(const char *str)
{
 char *Cad;
 if(!(Cad=new char[strlen(this->contenido)+strlen(str)+1]))
   _error=2;
 strcpy(Cad, this->contenido);
 strcat(Cad, str);
 delete this->contenido;
 longi=strlen(Cad);
 if(!(contenido=new char[longi+1]))
   _error=2;
 strcpy(this->contenido, Cad);
 delete Cad;       //  Es interesante liberar manualmente la memoria.
 }

//  Compo: Compone una cadena (con char *) a partir de otras 2.
void Cadena :: compo(const char *str, const char *str2)
{
 delete contenido;
 longi=strlen(str)+strlen(str2);
 if(!(contenido=new char[longi+1]))
   _error=2;
 strcpy(contenido, str);
 strcat(contenido, str2);
 }

//  Compo: Compone una cadena a partir de otras 2.
void Cadena :: compo(const Cadena &str, const char *str2)
{
 compo(str.contenido, str2);
 }

//  Compo: Otra variante.
void Cadena :: compo(const Cadena &str, const Cadena &str2)
{
 compo(str.contenido, str2.contenido);
 }

//  Compo: Otra variante.
void Cadena :: compo(const char *str, const Cadena &str2)
{
 compo(str, str2.contenido);
 }

//  Copia: Hace una cpia literal de la cadena.
void Cadena :: copia(const Cadena &str)
{
 delete contenido;
 longi=str.longi;
 if(!(contenido=new char[str.longi+1]))
   _error=2;
 strcpy(contenido, str.contenido);
 }

//  Copia: Hace una cpia literal del tipo predefinido char *.
void Cadena :: copia(const char *str)
{
 delete contenido;
 longi=strlen(str);
 if(!(contenido=new char[longi+1]))
   _error=2;
 strcpy(contenido, str);
 }

//  Operador << (surtida): redirige el flujo de salida.
ostream &operator << (ostream &out, const Cadena &str)
{
 out << str.contenido;
 return out;
 }

//  Operador >> (entrada): redirige el flujo de entrada.
istream &operator >> (istream &in, Cadena &str)
{
 char cad[MAX_LONG];
 in.getline(cad, MAX_LONG);
 str.longi=strlen(cad);
 delete str.contenido;
 str.contenido=new char[str.longi+1];
 strcpy(str.contenido, cad);
 return in;
 }

// num_letras: Devuelve el nmero de letras en la cadena.
int Cadena :: num_letras(void)
{
 return strlen(contenido);
 }

// num_palabras: Devuelve el nmero de palabras en la cadena.
int Cadena :: num_palabras(void)
{
 int i,j=0;
 for(int num_par=1; j<longi; num_par++)
  {                  		//  Fins que acabem una paraula.
   for(i=j; i<longi && contenido[i]!=' '; i++);
   for(j=i; j<longi && contenido[j]==' '; j++);
   }
 return num_par-1;
 }

// Letra: Este mtodo devuelve la letra de la posicin "index".
char Cadena :: letra(int index)
{
 return contenido[index-1];
 }

// Palabra: Devuelve la palabra index-sima.
Cadena Cadena :: palabra(int index)
{
 char *cad;
 int i, j, num_par;
 if(!(cad=new char[longi]))
   _error=2;

 for(num_par=1, j=0; j<longi && num_par<index; num_par++)
  {                             //  Hasta que acabemos una palabra.
   for(i=j; i<longi && contenido[i]!=' '; i++);
   for(j=i; j<longi && contenido[j]==' '; j++);
   }
 if(num_par==index)             //  Si hay suficientes palabras.
  {
   for(i=j; i<longi && contenido[i]!=' '; i++)
     cad[i-j]=contenido[i];
   cad[i-j]='\x0';
   }
  else
   _error=1;

 Cadena X(cad);
 delete cad;
 return X;
 }

// Igual: Indica si 2 cadenas son iguales.
int Cadena :: igual(const Cadena &str)
{
 return !strcmp(this->contenido, str.contenido);
 }

// Igual: Idem anterior para char *.
int Cadena :: igual(const char *str)
{
 return strcmp(this->contenido, str)==0;
 }

// Diferentes: Indica si 2 cadenas son diferentes.
int Cadena :: diferentes(const Cadena &str)
{
 return strcmp(this->contenido, str.contenido);
 }

// Diferentes: Idem para char *.
int Cadena :: diferentes(const char *str)
{
 return !strcmp(this->contenido, str);
 }

// Anterior: Compara alfabticamente 2 cadenas y dice si 'str' es anterior.
int Cadena :: anterior(const Cadena &str)
{
 int i;
 for(i=0; this->contenido[i]==str.contenido[i]; i++);
 return this->contenido[i]<str.contenido[i];
 }

// Anterior: Idem anterior para char *
int Cadena :: anterior(const char *str)
{
 int i;
 for(i=0; this->contenido[i]==str[i]; i++);
 return this->contenido[i]<str[i];
 }

// Posterior: Compara alfabticament 2 cadenes y dice si 'str' es posterior.
int Cadena :: posterior(const Cadena &str)
{
 int i;
 for(i=0; this->contenido[i]==str.contenido[i]; i++);
 return this->contenido[i]>str.contenido[i];
 }

// Posterior: Idem anterior para char *
int Cadena :: posterior(const char *str)
{
 int i;
 for(i=0; this->contenido[i]==str[i]; i++);
 return this->contenido[i]>str[i];
 }

// Donde: Dice donde se encuentra una subcadena (que palabra es). Devuelve -1
//        si no encontrado.
int Cadena :: donde(const Cadena &str)
{
 return this->donde(str.contenido);
 }

// Donde: Idem anterior para char *
int Cadena :: donde(const char *str)
{
 char *ptr;
 int i, j, k, fin;

 j=0; fin=1==0;
 while(!fin)
  {
   k=0;
   for(i=j; contenido[i]!=str[0]; i++);	//  Espera la 1 coincidencia.
   for(j=i; contenido[j]==str[k]; j++)  //  Hasta que hayan diferencias.
     if(k++==strlen(str)-1)
      {
       fin=1==1;
       break;                           //  Tambien acabamos cuando es igual.
       }
   if(j>strlen(contenido)) fin=21;      //  Indicamos error (no encontrada).
   }

 int num_par;
 if(fin!=21)
  {
   for(k=0; k<j && contenido[k]==' '; k++);  // Pasamos los espacios en blanco.
   for(num_par=0; k<j; num_par++)
    {                           //  Hasta que acabemos una palabra.
     for(i=k; i<j && contenido[i]!=' '; i++);
     for(k=i; k<j && contenido[k]==' '; k++);
     }
   }
 else
   num_par=-1;
 return num_par;
 }
