;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;  Rutinas para controlar la memoria XMS en assembler  ;;;;
;;;;;;;;;;;  By Navi/PhyMosys - Vilamarxant 1997   ;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;  ATENCIN: Este fichero debe ser incluido dentro de la parte
;            de  cdigo  del programa para  poderse  ensamblar
;            correctamente.
;

;;;;  REA DE DATOS.
DriverXMS       DD      0       ;  Direccin del driver de XMS.
 Longitud       DD      0       ;  Las 5 variables que vienen a continuacin
 SHandle        DW      0       ; son la estructura que recibe la funcin de
 SOffset        DD      0       ; movimiento de datos para copiar desde/hasta
 DHandle        DW      0       ; XMS.
 DOffset        DD      0

MsgError        DB      'Se ha producido un error inesperado$'

;;;;  REA DE CODIGO.

;;; InicXMS: Inicializa la memoria XMS.
;;; Entrada: --
;;; Salida: Carry si error.
;;; Modifica: --
;;; Observaciones: "DriverXMS" se actualiza con un puntero al driver de XMS.
InicXMS         PROC
                PUSHA
                MOV     AX, 4300h
                INT     2Fh             ;  Chequeamos a ver si hay XMS.
                CMP     AL, 80h
                JNE    ErrorXMS         ;  Si est instalado el driver...
                PUSH    ES
                MOV     AX, 4310h       ;  Otra llamada al MUX para consegir
                INT     2Fh             ; la direccin del driver.
                MOV     WORD PTR CS:[DriverXMS+0], BX
                MOV     WORD PTR CS:[DriverXMS+2], ES
                POP     ES              ;  Guardamos las direcciones y
                CLC                     ; regresamos sin error.
                POPA
                RET
InicXMS         ENDP

;;; ReservaXMS: Reserva memoria XMS.
;;; Entrada: DX=Kb a reservar
;;; Salida: DX=Handle de XMS. Carry si error.
;;; Modifica: AX, BX y DX.
;;; Observaciones: --
ReservaXMS      PROC                    ;  Llamamos a la funcin 09h del
                MOV     AH, 09h         ; driver de XMS.
                CALL    DWORD PTR CS:[DriverXMS]
                OR      AX, AX
                JZ    ErrorXMS          ;  Si AX=0 entonces hay un error...
                RET
ReservaXMS      ENDP

;;; DevuelveXMS: Libera memoria XMS.
;;; Entrada: DX=Handle de XMS.
;;; Salida: Carry si error.
;;; Modifica: AX.
;;; Observaciones: --
DevuelveXMS     PROC
                MOV     AH, 0Ah         ;  La funcin 0Ah es la de liberacin.
                CALL    DWORD PTR CS:[DriverXMS]
                OR      AX, AX
                JZ    ErrorXMS          ;  Si hay algn error...
                RET
DevuelveXMS     ENDP

;;; CopiaXMS: Cpia de memoria baja a la XMS algo.
;;; Entrada: DX=Handle de XMS.
  ;          ECX=Longitud.
  ;          EBX=Desplazamiento (dentro de la MEM XMS).
  ;          DS:SI=Direccin origen.
;;; Salida: Carry si error.
;;; Modifica: --
;;; Observaciones: --
CopiaXMS        PROC
                PUSHAD
                XOR     EAX, EAX        ;  Lo primero es inicializar variables.
                MOV     CS:[Longitud], ECX
                MOV     CS:[DHandle], DX
                MOV     CS:[DOffset], EBX
                MOV     CS:[SHandle], AX
                MOV     WORD PTR CS:[SOffset+0], SI
                MOV     WORD PTR CS:[SOffset+2], DS
                PUSH    DS
                MOV     AX, CS          ;  Metemos en DS:SI la direccin de
                MOV     DS, AX          ; la estructura.
                MOV     SI, Offset Longitud
                MOV     AH, 0Bh         ;  La funcin 0Bh es la que cpia.
                CALL    DWORD PTR CS:[DriverXMS]
                OR      AX, AX
                JZ    ErrorXMS          ;  Si se produce algn error...
                POP     DS
                POPAD
                RET
CopiaXMS        ENDP

;;; CopiaMEM: Cpia de XMS a memoria baja.
;;; Entrada: DX=Handle de XMS.
  ;          ECX=Longitud.
  ;          EBX=Desplazamiento (dentro de la MEM XMS).
  ;          DS:SI=Direccin destino.
;;; Salida: Carry si error.
;;; Modifica: --
;;; Observaciones: --
CopiaMEM        PROC
                PUSHAD
                XOR     EAX, EAX        ;  Lo primero es inicializar variables.
                MOV     CS:[Longitud], ECX
                MOV     CS:[DHandle], AX
                MOV     CS:[SOffset], EBX
                MOV     CS:[SHandle], DX
                MOV     WORD PTR CS:[DOffset+0], SI
                MOV     WORD PTR CS:[DOffset+2], DS
                PUSH    DS
                MOV     AX, CS          ;  Metemos en DS:SI la direccin de
                MOV     DS, AX          ; la estructura.
                MOV     SI, Offset Longitud
                MOV     AH, 0Bh         ;  La funcin 0Bh es la que cpia.
                CALL    DWORD PTR CS:[DriverXMS]
                OR      AX, AX
                JZ    ErrorXMS          ;  Si se produce algn error...
                POP     DS
                POPAD
                RET
CopiaMEM        ENDP

;;;  Aqu se llama si hay algun error.
ErrorXMS        PROC
                PUSH    CS
                POP     DS
                MOV     DX, Offset MsgError
                MOV     AH, 9
                INT     21h             ;  Escribir un mensaje.
                MOV     AX, 4C03h
                INT     21h             ;  Salir al DOS.
ErrorXMS        ENDP
