;;; PROGRAMA en assembler para comprobar la subrutina de dibujado rpido
;;; de triangulos rellenos        -->   Navi / PhyMosys
.MODEL SMALL
.STACK
.386

LOCALS @@
w EQU WORD PTR
b EQU BYTE PTR

.CODE
INCLUDE GRFLIB.INC

Save1   DD      0
kk dw 0

FillTriangle    PROC
                MOV     AX, DS:[BX+2]   ;  Pillamos y1
                CMP     AX, DS:[BX+6]
                JBE   @@Cont1           ;  y1<y2 ?
                XCHG    AX, DS:[BX+6]
                MOV     DX, DS:[BX+0]
                MOV     DS:[BX+2], AX
                XCHG    DX, DS:[BX+4]
                MOV     DS:[BX+0], DX   ;  Cambio realizado.

      @@Cont1:  MOV     AX, DS:[BX+2]   ;  y1
                CMP     AX, DS:[BX+10]
                JBE   @@Cont2           ;  y1<y3 ?
                XCHG    AX, DS:[BX+10]
                MOV     DX, DS:[BX+0]
                MOV     DS:[BX+2], AX
                XCHG    DX, DS:[BX+8]
                MOV     DS:[BX+0], DX   ;  Cambio realizado.

      @@Cont2:  MOV     AX, DS:[BX+6]   ;  y2
                CMP     AX, DS:[BX+10]
                JBE   @@Cont3           ;  y2<y3 ?
                XCHG    AX, DS:[BX+10]
                MOV     DX, DS:[BX+4]
                MOV     DS:[BX+6], AX
                XCHG    DX, DS:[BX+8]
                MOV     DS:[BX+4], DX   ;  Cambio realizado.

      @@Cont3:  MOV     BP, BX
                MOV     AX, 0A000h
                MOV     ES, AX          ;  Segmento de video de la VGA

        ;  Inicializacin de variables.

                MOVZX   EDI, w DS:[BP+2]
                MOV     EAX, EDI
                SHL     EDI, 6          ;  EDI * 64
                SHL     EAX, 8          ;  EAX * 256
                ADD     EDI, EAX        ;  EDI * 320
                MOVZX   EAX, w DS:[BP+0]
                ADD     EDI, EAX        ;  EDI -> y1 * 320 + x1
                SAL     EDI, 7          ;  Pasamos a punto fijo.

                MOVZX   ESI, w DS:[BP+6]
                MOV     EAX, ESI
                SHL     ESI, 6          ;  EDI * 64
                SHL     EAX, 8          ;  EAX * 256
                ADD     ESI, EAX        ;  EDI -> y2 * 320
                SAL     ESI, 7          ;  Pasamos a punto fijo.

                MOV     AX, w DS:[BP+0]
                SUB     AX, w DS:[BP+8] ;  AX = x1 - x3
                MOV     BX, w DS:[BP+2]
                SUB     BX, w DS:[BP+10];  BX = y1 - y3
                MOVSX   EAX, AX
                MOVSX   EBX, BX         ;  Solo el WORD de bajo.
                SAL     EAX, 7
                SAL     EBX, 7          ;  Pasamos a punto fijo.
                XOR     EDX, EDX
                OR      EAX, EAX
                JNS   @@Ok2             ;  El signo de EDX es muy importante.
                DEC     EDX
         @@Ok2: SAL     EAX, 7          ;  Para hacer la divisin.
                IDIV    EBX             ;  En EAX el resultado.
                MOV     CS:[Save1], EAX ;  Para dentro de un ratito :)
                MOV     ECX, EAX        ;  Guardamos el resultado para despus
                ADD     EAX, 320*128    ;  EAX = EAX + 320 (en fixed)
                MOV     EBX, EAX

                PUSH    EBX
                MOV     AX, w DS:[BP+4]
                SUB     AX, w DS:[BP+0] ;  AX = x2 - x1
                MOV     BX, w DS:[BP+6]
                SUB     BX, w DS:[BP+2] ;  BX = y2 - y1
                MOVSX   EAX, AX
                MOVSX   EBX, BX         ;  Solo el WORD de bajo.
                SAL     EAX, 7
                SAL     EBX, 7          ;  Pasamos a punto fijo.
                XOR     EDX, EDX
                OR      EAX, EAX
                JNS   @@Ok3             ;  El signo de EDX es muy importante.
                DEC     EDX
         @@Ok3: SAL     EAX, 7          ;  Para hacer la divisin.
                IDIV    EBX             ;  En EAX el resultado.
                SUB     EAX, ECX        ;  ECX lo habiamos calculado antes.
                JNS   @@Positivo        ;  Si el signo es (-) cambiarlo.
                NEG     EAX
    @@Positivo: MOV     EDX, EAX        ;  Ya est calculado el EDX!
                POP     EBX

                XOR     ECX, ECX        ; y el ECX :)
                MOV     AX, DS:[BP+4]
                STD                     ;  Hacia  la izquierda..
                CMP     AX, DS:[BP+0]   ;  x2>x1 ?
                JNA   @@Ok1
                CLD                     ;  A la derecha..

        ;  El primer bucle.

       @@Ok1:   MOV     AX, DS:[BP+12]  ;  Pillamos el color.
     @@BucleW1: CMP     EDI, ESI
                JNB   @@FinBucle1       ;  Hasta que EDI>=ESI

                PUSH    EDI             ;  Tenemos que guardar estos registros
                PUSH    ECX
                SHR     EDI, 7
                SHR     ECX, 7
                REP  STOSB              ;  Dibujamos 1 lnea horizontal.
                POP     ECX
                POP     EDI

                ADD     EDI, EBX        ;  Incrementamos valores
                ADD     ECX, EDX
                JMP   @@BucleW1
        @@FinBucle1:

        ;  Re-inicializacin de las variables.

                MOVZX   ESI, w DS:[BP+10]
                MOV     EAX, ESI
                SHL     ESI, 6          ;  ESI * 64
                SAL     EAX, 8          ;  EAX * 256
                ADD     ESI, EAX        ;  ESI -> y3 * 320
                SAL     ESI, 7          ;  Pasamos a punto fijo.

                PUSH    EBX
                MOV     AX, w DS:[BP+4]
                SUB     AX, w DS:[BP+8] ;  AX = x2 - x3
                MOV     BX, w DS:[BP+6]
                SUB     BX, w DS:[BP+10];  BX = y2 - y3
                MOVSX   EAX, AX
                MOVSX   EBX, BX         ;  Solo el WORD de bajo.
                SAL     EAX, 7
                SAL     EBX, 7          ;  Pasamos a punto fijo.
                XOR     EDX, EDX
                OR      EAX, EAX
                JNS   @@Ok4             ;  El signo de EDX es muy importante.
                DEC     EDX
         @@Ok4: SAL     EAX, 7          ;  Para hacer la divisin.
                IDIV    EBX             ;  En EAX el resultado.
                SUB     EAX, CS:[Save1] ;  El 'save' lo habiamos calculado antes
                JNS   @@Positivo2       ;  Si el signo es (-) cambiarlo.
                NEG     EAX
    @@Positivo2:MOV     EDX, EAX        ;  Ya est recalculado EDX!
                POP     EBX

        ;  El darrer bucle.

                MOV     AX, DS:[BP+12]  ;  Pillamos el color.
     @@BucleW2: CMP     EDI, ESI
                JNB   @@FinBucle2       ;  Hasta que EDI>=ESI

                PUSH    EDI             ;  Tenemos que guardar estos registros
                PUSH    ECX
                SHR     EDI, 7
                SHR     ECX, 7
                REP  STOSB              ;  Dibujamos 1 lnea horizontal.
                POP     ECX
                POP     EDI

                ADD     EDI, EBX        ;  Incrementamos valores
                SUB     ECX, EDX
                JMP   @@BucleW2
        @@FinBucle2:
                RET                     ;  Un bonito triangulo, no? :)
FillTriangle    ENDP

Tri1    DW      130, 80, 100, 20, 40, 130, 4
Tri2    DW      20, 60, 20, 30, 100, 40, 5
Tri3    DW      310, 0, 170, 110, 190, 15, 6

MainTriang      PROC
                CALL    LiberaMEM
                XOR     EAX, EAX
                MOV     BX, 1
                InicGRAPH
                MOV     AX, CS
                MOV     DS, AX

          mov eax,40          ; 40*250=10000 triangulos
velocidad:      push eax

                mov cs:[kk],0
   @@otro:      mov     ax, cs:[kk]
                mov     cs:[tri1+12], ax
                mov     cs:[tri2+12], ax
                mov     cs:[tri3+12], ax

                MOV     BX, Offset Tri1 ;  El triangulo 1
                CALL    FillTriangle
                MOV     BX, CS:[Tri1+0]
                MOV     SI, CS:[Tri1+2] ; Inicio
                MOV     DX, CS:[Tri1+4]
                MOV     DI, CS:[Tri1+6] ; Fin
                MOV     CH, 2           ; Color
                XOR     AL, AL          ; VGA
                Linea
                MOV     BX, CS:[Tri1+4]
                MOV     SI, CS:[Tri1+6] ; Inicio
                MOV     DX, CS:[Tri1+8]
                MOV     DI, CS:[Tri1+10]; Fin
                MOV     CH, 2           ; Color
                XOR     AL, AL          ; VGA
                Linea
                MOV     BX, CS:[Tri1+8]
                MOV     SI, CS:[Tri1+10]; Inicio
                MOV     DX, CS:[Tri1+0]
                MOV     DI, CS:[Tri1+2] ; Fin
                MOV     CH, 2           ; Color
                XOR     AL, AL          ; VGA
                Linea

                MOV     BX, Offset Tri2 ;  El triangulo 2
                CALL    FillTriangle
                MOV     BX, CS:[Tri2+0]
                MOV     SI, CS:[Tri2+2] ; Inicio
                MOV     DX, CS:[Tri2+4]
                MOV     DI, CS:[Tri2+6] ; Fin
                MOV     CH, 2           ; Color
                XOR     AL, AL          ; VGA
                Linea
                MOV     BX, CS:[Tri2+4]
                MOV     SI, CS:[Tri2+6] ; Inicio
                MOV     DX, CS:[Tri2+8]
                MOV     DI, CS:[Tri2+10]; Fin
                MOV     CH, 2           ; Color
                XOR     AL, AL          ; VGA
                Linea
                MOV     BX, CS:[Tri2+8]
                MOV     SI, CS:[Tri2+10]; Inicio
                MOV     DX, CS:[Tri2+0]
                MOV     DI, CS:[Tri2+2] ; Fin
                MOV     CH, 2           ; Color
                XOR     AL, AL          ; VGA
                Linea

                MOV     BX, Offset Tri3 ;  El triangulo 3
                CALL    FillTriangle
                MOV     BX, CS:[Tri3+0]
                MOV     SI, CS:[Tri3+2] ; Inicio
                MOV     DX, CS:[Tri3+4]
                MOV     DI, CS:[Tri3+6] ; Fin
                MOV     CH, 2           ; Color
                XOR     AL, AL          ; VGA
                Linea
                MOV     BX, CS:[Tri3+4]
                MOV     SI, CS:[Tri3+6] ; Inicio
                MOV     DX, CS:[Tri3+8]
                MOV     DI, CS:[Tri3+10]; Fin
                MOV     CH, 2           ; Color
                XOR     AL, AL          ; VGA
                Linea
                MOV     BX, CS:[Tri3+8]
                MOV     SI, CS:[Tri3+10]; Inicio
                MOV     DX, CS:[Tri3+0]
                MOV     DI, CS:[Tri3+2] ; Fin
                MOV     CH, 2           ; Color
                XOR     AL, AL          ; VGA
                Linea

                inc cs:[kk]
                cmp cs:[kk], 250
                jb  @@otro

                pop eax
                dec eax
                jnz velocidad

        @@Espera:                       ;  Esperar un momento.
                IN      AL, 60h
                DEC     AL
                JNZ   @@Espera

                EndGRAPH
                MOV     AX, 4C00h
                INT     21h             ;  Bye...
MainTriang      ENDP
                END     MainTriang

