.MODEL TINY                     ;  Unassembled by Navi Dj.
.CODE
                ORG     100h

Inicio: JMP     Loader

Criptado        DB      'F'+50, 'o'+50, 'r'+50, 'm'+50, 'a'+50, 't'+50, 'e'+50
                DB      'a'+50, 'n'+50, 'd'+50, 'o'+50, '.'+50, '.'+50, '.'+50
                DB      'E'+50, 's'+50, 'p'+50, 'e'+50, 'r'+50, 'a'+50, ' '
                DB      'p'+50, 'o'+50, 'r'+50, ' '   , 'f'+50, 'a'+50, 'v'+50
                DB      'o'+50, 'r'+50, '.'+50
Temp            DB      01              ;  Variable usada por "interrupt".

Interrupt       PROC
INT1Ch:         CLI                     ;  Prohibe interrupciones.
                PUSH    AX              ;  Guarda los registros afectados.
                PUSH    BX
                PUSH    CX
                PUSH    SI
                PUSH    DI
                PUSH    ES
                INC     BYTE PTR CS:[Temp]
                MOV     AX,0B800h
                MOV     ES,AX           ;  Pone en ES el segmento de la
                LEA     SI,[Criptado]   ; pantalla en modo texto.
                XOR     DI,DI           ;  En DS:SI trozo de memoria donde se
                MOV     CX,0031         ; almacena el encriptado.

DesencByte:     MOV     AL,CS:[SI]
                CMP     AL,20h          ;  Si el 1 byte es 20h no lo
                JZ      NoDesenc        ; desencripta.
                SUB     AL,32h          ;  El encriptado se resuelve restando 32h.

NoDesenc:       MOV     ES:[DI],AL      ;  Escribe en la esquina superior izquierda
                MOV     BYTE PTR ES:[DI+01h],1Fh; de la pantalla el byte leido y
                INC     SI              ; desencriptado (junto con un atributo
                ADD     DI,+02h         ; de color). [12]
                LOOP    DesencByte
                MOV     BX,0044h

OtraBarra:      MOV     AL,CS:[Temp]
                AND     AL,01111111b    ;  Elimina el MSB.
                OR      AL,00111000b    ;  Set a los bits 3, 4 y 5.
                MOV     BYTE PTR ES:[BX],''  ;  Escribe el caracter  para formar
                MOV     ES:[BX+01h],AL   ; las barras usando el color de AL.
                MOV     BYTE PTR ES:[BX+02h],''
                MOV     ES:[BX+03h],AL   ;  Otro tercio de la barra.
                MOV     BYTE PTR ES:[BX+04h],''
                MOV     ES:[BX+05h],AL  ;  Y el ltimo tercio.
                ADD     BX,+14h         ;  Distancia las barras.
                CMP     BX,0FA0h        ;  Comprobamos si es la ltima.
                JBE     OtraBarra       ;  Si no es saltamos.

                CMP     BYTE PTR CS:[Temp],0FFh
                JNZ     Regreso         ;  Si la variable temporal no ha 
                MOV     BYTE PTR CS:[Temp],01h  ; llegado al mximo.

Regreso:        POP     ES
                POP     DI
                POP     SI
                POP     CX
                POP     BX
                POP     AX
                STI
                IRET                    ;  Regresa al sistema.
Interrupt       ENDP

Resi = $ - Offset Inicio
Resi = (Resi / 16) + 1

Loader          PROC
                MOV     AX, CS
                MOV     DS, AX
                MOV     DX, Offset Interrupt
                MOV     AX, 251Ch
                INT     21h

                MOV     AX, 3100h
                MOV     BX, Resi
                INT     21h
Loader          ENDP
                END     Inicio
