;;;;;;;  Visualizador de sprites.     NAVI Dj.
.MODEL SMALL
.STACK
.386

.DATA
SPRName         DB  13 DUP (0)          ;  Nombre del fichero con el sprite.
SizeX           DW      0
SizeY           DW      0               ;  Tamao del sprite
MsgError        DB  'ERROR. Sintaxis correcta:',0Dh,0Ah
                DB  '       SPRVIS  /Snombre_sprite /Xtamao_x /Ytamao_y',0Dh,0Dh,0Ah
                DB  ' Los tamaos se deben especificar con 3 dgitos obligatoriamente.$'

.CODE
INCLUDE GRFLIB.INC

LineaCmds       PROC
                MOV     DI, 80h         ;  Apunta a la lnea de comandos.
                XOR     CH, CH
                MOV     CL, ES:[DI]     ;  Cogemos la longitud.
                INC     DI

        @@BuscaCaracter:
                MOV     AL, ES:[DI]
                INC     DI
                CMP     AL, '/'
                JNE   @@BuscaCaracter
                CMP     DI, 0FFh
                JA    @@Final
        @@Comando:
                MOV     AL, ES:[DI]
                INC     DI
                CMP     AL, 'S'
                JE    @@SPRName
                CMP     AL, 'X'
                JE    @@SizeX
                CMP     AL, 'Y'
                JNE   @@BuscaCaracter
          @@SizeY:
                XOR     DX, DX
                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                MOV     AH, 100
                MUL     AH
                ADD     DX, AX
                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                MOV     AH, 10
                MUL     AH
                ADD     DX, AX
                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                ADD     DX, AX
                MOV     [SizeY], DX
                JMP   @@BuscaCaracter
          @@SizeX:
                XOR     DX, DX
                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                MOV     AH, 100
                MUL     AH
                ADD     DX, AX
                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                MOV     AH, 10
                MUL     AH
                ADD     DX, AX
                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                ADD     DX, AX
                MOV     [SizeX], DX
                JMP   @@BuscaCaracter
          @@SPRName:
                MOV     SI, Offset SPRName
              @@BucleSPR:
                MOV     AL, ES:[DI]
                INC     DI
                CMP     AL, ' '
                JE    @@FinSPR
                PUSH    DI
                SUB     DI, CX
                SUB     DI, 2
                CMP     DI, 80h
                POP     DI
                JNB   @@FinSPR
                MOV     DS:[SI], AL
                INC     SI
                JMP   @@BucleSPR
              @@FinSPR:
                MOV     BYTE PTR DS:[SI], 0
                JMP   @@BuscaCaracter
        @@Final:RET
LineaCmds       ENDP

Visualizador    PROC
                MOV     AX, @DATA
                MOV     DS, AX
                CALL    LiberaMEM
                CALL    ModoGrafico     ;  Encendemos GRAPH.
                CALL    TrataError

                CALL    LineaCmds
                MOV     DX, Offset SPRName
                MOV     BX, [SizeX]
                MOV     CX, [SizeY]
                CALL    CargaSprite     ;  Cargamos el sprite.
                PUSH    DS
                CALL    TrataError
                POP     DS
                CMP     AL, 0FFh
                JE    @@Error
                PUSH    AX
                MOV     AH, AL
                XOR     AL, AL
                XOR     BP, BP
                XOR     BX, BX
                CALL    DibujaSprite    ;  Dibujamos el sprite.
                CALL    TrataError
                POP     AX
                CALL    DestSprite

        @@Espera:
                IN      AL, 60h
                CMP     AL, 81h
                JNE   @@Espera          ;  Espera que se pulse ESC.

                XOR     DX, DX
                MOV     CX, 8000h
                CALL    FadeDown        ;  Hace un fade.
                CALL    ModoTexto
                MOV     AX, 4C00h
                INT     21h             ;  Salir al DOS.

        @@Error:CALL    ModoTexto
                MOV     AH, 9
                MOV     DX, Offset MsgError
                INT     21h
                MOV     AX, 4C01h
                INT     21h
Visualizador    ENDP
                END     Visualizador
