/*         MAD-MAKER  ..............................  By Navi Dj.
 *                      Compilador de formatos MAD
 *                        Vilamarxant 1996  v1.0
 *                     Formatos de la 1era revisin
 *                   ................................
 */

#include <sys\stat.h>
#include <string.h>
#include <conio.h>
#include <stdio.h>
#include <fcntl.h>
#include <alloc.h>
#include <dos.h>
#include <io.h>
#include "cajas.h"

#define FMTVERSION 1            //  Versin del formato.
#define LEER       0            //  Para que dibuja_scr espere o no una
#define ESCRIBIR   1, NULL      // cadena del usuario.

struct cabMAD {
	char  pertenencia[0x20];
	char  _EOF;
	long  tamanyo;
	char  identificador[0x04];
	char  version;
	};
      
   

//  Esta funcin dibuja la pantalla principal y si el modo est en LEER,
// espera la introduccin de una cadena de carcteres y la almacena en
// "cadena". Tambien imprime la cadena "mensaje".

void dibuja_scr(const char *mensaje, unsigned char modo, char *cadena)
{                                       //  Atencin mensaje mximo de largo
 clrscr();                              // de 80 letras.

 textcolor(RED);
 cprintf("                      MAD-MAKER v1.0  ---  Por Navi Dj.\n\r");
 cprintf("*******************************************************************************\n\r");

 textcolor(GREEN);
 gotoxy(8,10);
 cprintf("A. Abrir fichero .MAD");
 gotoxy(8,11);
 cprintf("B. Guardar fichero .MAD");
 gotoxy(8,12);
 cprintf("C. Borrar archivo");
 gotoxy(8,13);
 cprintf("D. Incluir archivo");
 gotoxy(8,14);
 cprintf("E. Salir al DOS");

 textcolor(WHITE);
 gotoxy(1,23);
 cprintf("*******************************************************************************\n\r");
 cprintf(mensaje);
 if(modo==LEER) scanf("%80s",cadena);
 }

void main(void)
{
 char   tecla=1;
 char   *file_in, *mem_ptr, *texto;
 int    hdl_file, aux_hdl, stat;
 unsigned int  file_open=0, NEW=0, tipo, campo, dato, seg;
 unsigned int far *aux_mem;
 long   longitud;
 struct cabMAD MAD_hdr;

 dibuja_scr("MAD-MAKER preparado para funcionar.", ESCRIBIR);

 while(tecla!=0)
  {
   tecla=getch();
   switch(tecla) {
     case 'A':
     case 'a':
       NEW=0;
       if(file_open)
	{
	 dibuja_scr("Ya existe un fichero abierto.", ESCRIBIR);
	 break;
	 }
       dibuja_scr("Escribe el nombre del fichero: ", LEER, file_in);
       if((hdl_file=open(file_in, O_RDWR | O_BINARY))==0xffff)
	 hdl_file=creat(file_in, S_IREAD | S_IWRITE);   // Si no existe lo creamos.
       if((read(hdl_file, &MAD_hdr, sizeof(MAD_hdr)))==0)
	{
	 MAD_hdr.tamanyo=sizeof(MAD_hdr);
	 strcpy(MAD_hdr.identificador, "IGSX");
	 MAD_hdr._EOF=0x1a; MAD_hdr.version=1;
	 write(hdl_file, &MAD_hdr, sizeof(MAD_hdr));
	 dibuja_scr("Nmero mximo de campos? ", LEER, texto);
	 MAD_hdr.tamanyo+=14*atoi(texto);
	 NEW=1;
	 }
       if(!strcmp(MAD_hdr.identificador, "IGSX"))
	{
	 dibuja_scr("No se trata de un fichero vlido. Vuelvelo a intentar", ESCRIBIR);
	 break;
	 }
       mem_ptr=malloc(MAD_hdr.tamanyo+16);      //  Reservamos memoria.
       if(NEW)
	{
	 memset(mem_ptr, 0, MAD_hdr.tamanyo-sizeof(MAD_hdr));
	 write(hdl_file, mem_ptr, MAD_hdr.tamanyo-sizeof(MAD_hdr));
	 }
	else
	 read(hdl_file, mem_ptr, MAD_hdr.tamanyo-sizeof(MAD_hdr));
  //     informe(mem_ptr, (MAD_hdr.tamanyo/14)-3);
       dibuja_scr("Fichero abierto correctamente.", ESCRIBIR);
       file_open=1;
       break;   //  Ya hemos leido el fichero, tenemos su cabecera fija y su
		// cabecera variable.
     case 'B':
     case 'b':
       if(!file_open)
	{
	 dibuja_scr("No hay ningn fichero abierto.", ESCRIBIR);
	 break;
	 }
       MAD_hdr._EOF=0x1a;
       memset(texto, ' ', 0x20);
       dibuja_scr("Descripcin: ", LEER, texto);
       memmove(MAD_hdr.pertenencia, texto, 0x20);
       lseek(hdl_file, 0, SEEK_SET);
       write(hdl_file, &MAD_hdr, sizeof(MAD_hdr));
       write(hdl_file, mem_ptr, MAD_hdr.tamanyo-sizeof(MAD_hdr));
       close(hdl_file);
       free(mem_ptr);
       dibuja_scr("Fichero guardado correctamente.", ESCRIBIR);
       file_open=0;
       break;
     case 'C':
     case 'c':
       if(!file_open)
	{
	 dibuja_scr("No hay ningn fichero abierto.", ESCRIBIR);
	 break;
	 }
       dibuja_scr("Nmero de campo total a borrar? ", LEER, texto);
       *(mem_ptr+(14*atoi(texto)))=0;
       dibuja_scr("OK! Campo borrado", ESCRIBIR);
       break;
     case 'D':
     case 'd':
       if(!file_open)
	{
	 dibuja_scr("No hay ningn fichero abierto.", ESCRIBIR);
	 break;
	 }
       dibuja_scr("Nmero de campo total? ", ESCRIBIR);
       scanf("%80s", texto);
       campo=atoi(texto);

       dibuja_scr("Tipo? ", ESCRIBIR);
	cuadro1(10, 50, 14, 68, 9);             //  Menu de opciones.
	textcolor(CYAN);
	gotoxy(52, 11); cprintf("1 --> GRAFICO");
	gotoxy(52, 12); cprintf("2 --> SONIDO");
	gotoxy(52, 13); cprintf("3 --> DATOS");
       gotoxy(7, 24);
       scanf("%80s", texto);
       tipo=atoi(texto);
       *(mem_ptr+campo*14)=(unsigned char)tipo;

       dibuja_scr("Handle? ", ESCRIBIR);
       scanf("%80s", texto);
       dato=atoi(texto);
       memcpy((mem_ptr+1+campo*14), &dato, 2);

       dibuja_scr("Compresion? ", ESCRIBIR);
	cuadro1(10, 50, 14, 68, 9);
	textcolor(CYAN);
	gotoxy(52, 11); cprintf("1 --> Ninguna");
	gotoxy(52, 12); cprintf("2 --> RLE*");
	gotoxy(52, 13); cprintf("3 --> Huffman*");
       gotoxy(13, 24);
       scanf("%80s", texto);
       *(mem_ptr+3+campo*14)=(unsigned char)atoi(texto);

       dibuja_scr("Sub-tipo? ", ESCRIBIR);
       switch(tipo) {
	 case 1:
	   cuadro1(7, 50, 19, 76, 9);
	   textcolor(CYAN);
	   gotoxy(52,  8); cprintf("0 --> Sin especificar");
	   gotoxy(52,  9); cprintf("1 --> RAW (bitmap)");
	   gotoxy(52, 10); cprintf("2 --> PCX");
	   gotoxy(52, 11); cprintf("3 --> BMP");
	   gotoxy(52, 12); cprintf("4 --> GIF");
	   gotoxy(52, 13); cprintf("5 --> FLI/FLC");
	   gotoxy(52, 14); cprintf("6 --> TGA");
	   gotoxy(52, 15); cprintf("7 --> Paleta");
	   gotoxy(52, 16); cprintf("8 --> Sprite");
	   gotoxy(52, 17); cprintf("9 --> Bloke de sprites");
	   break;
	 case 2:
	   cuadro1(7, 50, 15, 75, 9);
	   textcolor(CYAN);
	   gotoxy(52,  8); cprintf("0 --> Sin especificar");
	   gotoxy(52,  9); cprintf("1 --> RAW (Sample)");
	   gotoxy(52, 10); cprintf("2 --> VOC");
	   gotoxy(52, 11); cprintf("3 --> WAV");
	   gotoxy(52, 12); cprintf("4 --> MOD");
	   gotoxy(52, 13); cprintf("5 --> CMF");
	   gotoxy(52, 14); cprintf("6 --> MIDI");
	   break;
	 case 3:
	   cuadro1(12, 50, 17, 75, 9);
	   textcolor(CYAN);
	   gotoxy(52, 13); cprintf("0 --> Sin especificar");
	   gotoxy(52, 14); cprintf("1 --> ASCII");
	   gotoxy(52, 15); cprintf("2 --> COM");
	   gotoxy(52, 16); cprintf("3 --> EXE");
	}
       gotoxy(13, 24);
       scanf("%80s", texto);
       dato=atoi(texto);
       memcpy((mem_ptr+4+campo*14), &dato, 2);

       dibuja_scr("Nombre del archivo? ", LEER, texto);
       aux_hdl=open(texto, O_RDONLY | O_BINARY);
       longitud=filelength(hdl_file);
       memcpy((mem_ptr+6+campo*14), &longitud, 4);
       longitud=filelength(aux_hdl);
	if(longitud==0)
	 {
	  dibuja_scr("No hay suficiente memoria disponible.", ESCRIBIR);
	  break;
	  }
       memcpy((mem_ptr+10+campo*14), &longitud, 4);
	if((stat=allocmem((longitud/16)+1,&seg))>=0)
	 {
	  dibuja_scr("No hay suficiente memoria disponible.", ESCRIBIR);
	  break;
	  }
	aux_mem=MK_FP(seg,0);
	lseek(aux_hdl, 0, SEEK_SET);
	read(aux_hdl, aux_mem, (unsigned int)longitud);
	lseek(hdl_file, 0, SEEK_END);
	write(hdl_file, aux_mem, (unsigned int)longitud);
       freemem(seg);
       close(aux_hdl);
       dibuja_scr("OK! Fichero aadido", ESCRIBIR);
       break;
     case 'E':
     case 'e':
  //     informe(mem_ptr, (MAD_hdr.tamanyo/14)-3);
       tecla=0; break;
     }
   }
 }
