/*
 
  GargonScene n4 - Librera grfica para escribir en modo grfico (13h) 
                                                                         
  Coded by eXcalibur / Gargon Soft.                                      
 
*/
#ifndef __STDIO_H
  #include <STDIO.H>
#endif

unsigned char Chars8x8[256][8];
unsigned char Chars8x16[256][16];

/* Declaracin de la funciones de la librera -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-/
/* Funciones de T. 8x8 */
char IniFont8x8();
void Write8x8(int X, int Y, unsigned char *Cadena, unsigned char Color, unsigned char *Where);
void WriteCur8x8(int X, int Y, unsigned char *Cadena, unsigned char Color, unsigned char *Where);
void WriteSdw8x8(int X, int Y, unsigned char *Cadena, unsigned char Color, unsigned char ColorSombra, unsigned char *Where);
void WriteNeg8x8(int X, int Y, unsigned char *Cadena, unsigned char Color, unsigned char *Where);
void WriteChar8x8(int X, int Y, unsigned char Car, unsigned char Color, unsigned char *Where);

/* Funciones de T. 8x16 */
char IniFont8x16(char *Ficher, long Offset);
void Write8x16(int X, int Y, unsigned char *Cadena, unsigned char Color, unsigned char *Where);
void WriteCur8x16(int X, int Y, unsigned char *Cadena, unsigned char Color, unsigned char *Where);
void WriteSdw8x16(int X, int Y, unsigned char *Cadena, unsigned char Color, unsigned ColorSombra, unsigned char *Where);
void WriteNeg8x16(int X, int Y, unsigned char *Cadena, unsigned char Color, unsigned char *Where);
void WriteChar(int X, int Y, unsigned char Car, unsigned char Color, unsigned char *Where);

/* Complementarias a las otras. */
int  StrLen(char *String);


/**/
/* FUENTES DE 8X8                                                        */
/**/
/**/

/* IniFont8x8() ------------------------------------------------------------
        Inicializa las fuentes de 8X8. TIENE QUE SER LLAMADA ANTES DE USAR
   CUALQUIERA DE LAS FUNCIONES QUE UTILIZAN 8X8.
   -------------------------------------------------------------------------*/
char IniFont8x8()
{
 unsigned char *MemChars=(unsigned char *) 0xF000FA6E;
 int NumLetra, Cnt, Indice=0;

 for(NumLetra=0;NumLetra<256;NumLetra++)
         for(Cnt=0;Cnt<8;Cnt++)
                          Chars8x8[NumLetra][Cnt]=MemChars[Indice++];

 return 1;
}

/* Write8x8() --------------------------------------------------------------
        Escribe una cadena en pantalla de tamao 8x8 en el lugar especificado
   de la pantalla (x,y) y del color que le pasemos como argumento.
   -------------------------------------------------------------------------*/
void Write8x8(int X, int Y, unsigned char *Cadena, unsigned char Color, unsigned char *Where)
{
 register int Index, Line, Pos;
 register int Longit=StrLen(Cadena);

 for(Index=0;Index<Longit;Index++)
             for(Line=0;Line<8;Line++)
                  for(Pos=0;Pos<8;Pos++)
                        if(Chars8x8[Cadena[Index]][Line] & (256 >> Pos))
                                          Where[((Y+Line)<<8)+((Y+Line)<<6)+X+(Index<<3)+Pos]=Color;
}

/* WriteCur8x8() -----------------------------------------------------------
        Escribe una cadena en pantalla de tamao 8x8 en el lugar especificado
   de la pantalla (x,y) y del color que le pasemos como argumento, en CURSIVA.
   -------------------------------------------------------------------------*/
void WriteCur8x8(int X, int Y, unsigned char *Cadena, unsigned char Color, unsigned char *Where)
{
 register int Index, Line, Pos;
 register int Longit=StrLen(Cadena);
 X+=6;
 for(Index=0;Index<Longit;Index++)
                                 for(Line=0;Line<8;Line++)
                                        for(Pos=0;Pos<8;Pos++)
                                                         if(Chars8x8[Cadena[Index]][Line] & (256 >> Pos))
                                                                           Where[((Y+Line)<<8)+((Y+Line)<<6)+X+(Index<<3)+Pos-Line]=Color;
}

/* WriteSdw8x8() -----------------------------------------------------------
        Hace lo mismo que la funcin anterior, pero esta adems imprime la
   sombra a la cadena de caracteres.
   -------------------------------------------------------------------------*/
void WriteSdw8x8(int X, int Y, unsigned char *Cadena, unsigned char Color, unsigned char ColorSombra, unsigned char *Where)
{
 Write8x8(X+1,Y+1,Cadena,ColorSombra,Where);
 Write8x8(X,Y,Cadena,Color,Where);
}

/* WriteNeg8x8() -----------------------------------------------------------
        Esta funcin al igual que WriteSdw8x8() o WriteCur8x8() tambin hace
   un efecto con las fuentes, en este caso NEGRITA.
   -------------------------------------------------------------------------*/
void WriteNeg8x8(int X, int Y, unsigned char *Cadena, unsigned char Color, unsigned char *Where)
{
 Write8x8(X,Y,Cadena,Color,Where);
 Write8x8(X+1,Y,Cadena,Color,Where);
}

/* WriteChar8x8() ----------------------------------------------------------
         Esta funcion escribe un solo caracter en un lugar de la pantallla.
   -------------------------------------------------------------------------*/
void WriteChar8x8(int X, int Y, unsigned char Car, unsigned char Color, unsigned char *Where)
{
 register int Line, Pos;

 for(Line=0;Line<8;Line++)
        for(Pos=0;Pos<8;Pos++)
                         if(Chars8x8[Car][Line] & (256 >> Pos))
                                           Where[((Y+Line)<<8)+((Y+Line)<<6)+X+Pos]=Color;
}

/**/
/* FUENTES DE 8X16                                                       */
/**/
/**/

/* IniFont8x16() ----------------------------------------------------------
    Esta funcin carga la fuente que utilizar las funciones que manejan le-
   tras del tamao de 8X16. El archivo tiene que ser una fuente (.fnt) que
   ocupe 4096 bytes (8x16x256). TIENE QUE SER LLAMADA ANTES DE USAR LAS
   DEMAS FUNCIONES DE 8X16 ya que si no es as, no veremos los caracteres en
   pantalla, ya que no se han cargado en memoria.
   ------------------------------------------------------------------------*/
char IniFont8x16(char *Fichero, long Offset)
{
 FILE *Fp;
 register int NumLetra,  Cnt;

 if((Fp=fopen(Fichero,"rb"))==NULL)
                           return 0;

 fseek(Fp, Offset, SEEK_SET);

 for(NumLetra=0;NumLetra<256;NumLetra++)
         for(Cnt=0;Cnt<16;Cnt++)
                  Chars8x16[NumLetra][Cnt]=fgetc(Fp);

 fclose(Fp);
 return 1;
}

/* Write8x16() -------------------------------------------------------------
        Escribe una cadena en la Pos especificada, del color que queramos
   en un lugar de la memoria, que pasamos como punetero en *Where.
   -------------------------------------------------------------------------*/
void Write8x16(int X, int Y, unsigned char *Cadena, unsigned char Color, unsigned char *Where)
{
 register int Index, Line, Pos;
 register int Longit=StrLen(Cadena);

 for(Index=0;Index<Longit;Index++)
                                 for(Line=0;Line<16;Line++)
                                        for(Pos=0;Pos<9;Pos++)
                                                 if(Chars8x16[Cadena[Index]][Line] & (256 >> Pos))
                                                                   Where[((Y+Line)<<8)+((Y+Line)<<6)+X+(Index<<3)+Pos]=Color;
}

/* WriteCur8x16() ----------------------------------------------------------
        Escribe una cadena en la Pos especificada, del color que queramos
   en un lugar de la memoria, que pasamos como punetero en *Where, y en CURSIVA.
   -------------------------------------------------------------------------*/
void WriteCur8x16(int X, int Y, unsigned char *Cadena, unsigned char Color, unsigned char *Where)
{
 register int Index, Line, Pos;
 register int Longit=StrLen(Cadena);
 X+=14;
 for(Index=0;Index<Longit;Index++)
                                 for(Line=0;Line<16;Line++)
                                        for(Pos=0;Pos<9;Pos++)
                                                 if(Chars8x16[Cadena[Index]][Line] & (256 >> Pos))
                                                                   Where[((Y+Line)<<8)+((Y+Line)<<6)+X+(Index<<3)+Pos-Line]=Color;
}

/* WriteSdw8x16() -------------------------------------------------------------
        Hace lo mismo que Write8x16, con la caracteristica que tambin nos dibuja
   la sombra de la letras del color que queramos.
   -------------------------------------------------------------------------*/
void WriteSdw8x16(int X, int Y, unsigned char *Cadena, unsigned char Color, unsigned ColorSombra, unsigned char *Where)
{
 Write8x16(X+1,Y+1,Cadena,ColorSombra,Where);
 Write8x16(X,Y,Cadena,Color,Where);
}

/* WriteNeg8x16() ----------------------------------------------------------
        Esta funcin en vez de hacer la frase con sombra como la de arriba, lo
   que hace es hacerla en negrita.
   -------------------------------------------------------------------------*/
void WriteNeg8x16(int X, int Y, unsigned char *Cadena, unsigned char Color, unsigned char *Where)
{
 Write8x16(X,Y,Cadena,Color,Where);
 Write8x16(X+1,Y,Cadena,Color,Where);
}

/* WriteChar8x16() ------------------------------------------------------------
        Dibuja un caracter en pantalla del color especificado en las coordenadas
   (X,Y).
   -------------------------------------------------------------------------*/
void WriteChar8x16(int X, int Y, unsigned char Car, unsigned char Color, unsigned char *Where)
{
 register int Line, Pos;

 for(Line=0;Line<16;Line++)
        for(Pos=0;Pos<9;Pos++)
                         if(Chars8x16[Car][Line] & (256 >> Pos))
                                           Where[((Y+Line)<<8)+((Y+Line)<<6)+X+Pos]=Color;
}

/* FUNCIONES COMPLEMENTARIAS -----------------------------------------------*/
/* StrLen() ----------------------------------------------------------------
        Nos da la longitud de una cadena ASCIIZ (acabada en \0).
   -------------------------------------------------------------------------*/
int StrLen(char *String)
{
  asm les di,[String]
  asm xor ax,ax

L1:
  asm mov dl,[es:di]
  asm test dl,dl
  asm je  L0
  asm inc di
  asm inc ax
  asm jne L1

L0:
 return _AX;
}
