/*
  GargonScene: Curso de programacin grfica.
  
   LIBRERIA DE MANEJO DE LA PALETA. GargonScene n3.                 
  
*/
#ifndef __STDIO_H
  #include <STDIO.H>
#endif

/* Declaracin del las funciones de la Unit. -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
void SetPal(char far *);
void GetPal(char far *);
void SetCol(char, char, char, char);
void DelPal(char col);
void FadeOut();
void FadeIn(char *);
void FadeTo(char *);
void RPalLeft(char *);
void RPalRight(char *);
void NegPal(char *);
void GreyPal(char *);
void RedPal(char *);
void GreenPal(char *);
void BluePal(char *);

/* Otras funciones complementarias */
void Outportb(int port, unsigned char dato);
unsigned char Inportb(int port);
void WRetr();

/**/
/* Funciones del manejo de la PALETA.                                   */
/**/
/**/

/* SetPal() -----------------------------------------------------------------
	Esta funcin lo que hace es establecer una paleta de colores en la tar-
   jeta de video.
   -------------------------------------------------------------------------*/
void SetPal(char far *paleta)
{
 asm {
      push ds
      lds si, [paleta]
      mov cx, 256*3
      mov al, 0
      mov dx, 3c8h
      out dx, al
      inc dx
      rep outsb
      pop ds
     }
}

/* GetPal() -----------------------------------------------------------------
	Funcin que lee la paleta actual de la pantalla, y la almacena en un
   lugar de la memoria dado por *Palette
   -------------------------------------------------------------------------*/
void GetPal(char far *paleta)
{
 asm {
      les di, [paleta]
      mov cx, 256*3
      mov al, 0
      mov dx, 3c7h
      out dx, al
      add dx, 2
      rep insb
     }
}

/* SetCol() -----------------------------------------------------------------
	Funcin que cambia los valores RGB de un color de la paleta (0-255)
   -------------------------------------------------------------------------*/
void SetCol(char color, char r, char g, char b)
{
 asm {
      mov dx, 0x3C8
      mov al, [color]
      out dx, al
      inc dx
      mov al, [r]
      out dx, al
      mov al, [g]
      out dx, al
      mov al, [b]
      out dx, al
     }
}


/* DelPal() ----------------------------------------------------------------
	Pone el dac a un valor determinado.
   -------------------------------------------------------------------------*/
void DelPal(char col)
{
 register int i;

 for(i=0;i<255;i++)
		SetCol(i,col,col,col);
}

/* FadeOut() ----------------------------------------------------------------
	Hace un fundido desde la paleta actual hasta llegar al negro.
   -------------------------------------------------------------------------*/
void FadeOut()
{
  char paleta[768];
  int x, y;

  GetPal(paleta);

  for (y=0; y<63; y++)
  {
      for (x=0;x<768;x++)
	if (paleta[x] > 0) paleta[x]--;
      WRetr ();
      SetPal(paleta);
  }
}

/* FadeIn() -----------------------------------------------------------------
	Hace un fundido desde cero (negro) hasta otra paleta pasada como argu-
   meto de la funcin.
   -------------------------------------------------------------------------*/
void FadeIn(char *paleta)
{
   char pal[768];
   int x, y;

  for (y=0;y<768;y++) pal[y] = 0;

  for (y=0; y<63; y++)
  {
      for (x=0;x<768;x++)
	if (pal[x] < paleta[x]) pal[x]++;

  WRetr();
  SetPal(pal);
  }
}

/* FadeTo() -----------------------------------------------------------------
	Hace un fundido de la paleta actual a otra pasada como argumento.
   -------------------------------------------------------------------------*/
void FadeTo(char *paleta)
{
   char pal[768];
   int x, y;

  GetPal(pal);

  for (y=0;y<63;y++)
  {
      for (x=0;x<768;x++)
      {
	if (pal[x] < paleta[x]) pal[x]++;
	if (pal[x] > paleta[x]) pal[x]--;
      }
  WRetr();
  WRetr();
  SetPal(pal);
 }
}

/* RotPalLeft() -------------------------------------------------------------
	Rota la paleta una posicin a la IZQUIERDA.
   -------------------------------------------------------------------------*/
void RPalLeft(char *paleta)
{
   char r, g, b;
   int x;

    r = paleta[0];
    g = paleta[1];
    b = paleta[2];
    for (x=0;x<765;x+=3)
    {
    paleta[x] = paleta[x+3];
    paleta[x+1] = paleta[x+4];
    paleta[x+2] = paleta[x+5];
    }
    paleta[765] = r;
    paleta[766] = g;
    paleta[767] = b;

    WRetr();
    SetPal(paleta);
}

/* RotPalRight() -----------------------------------------------------------
	Rota la paleta una posicin a la DERECHA.
   -------------------------------------------------------------------------*/
void RPalRight(char *paleta)
{
   char r, g, b;
   int x;

    r = paleta[765];
    g = paleta[766];
    b = paleta[767];
    for (x=767;x>3;x-=3)
    {
    paleta[x] = paleta[x-3];
    paleta[x-1] = paleta[x-4];
    paleta[x-2] = paleta[x-5];
    }
    paleta[0] = r;
    paleta[1] = g;
    paleta[2] = b;

    WRetr();
    SetPal(paleta);
}

/* GreyPal() ----------------------------------------------------------------
	Esta funcin pasa a escala de grises la paleta actual.
   -------------------------------------------------------------------------*/
void GreyPal(char *pal)
{
  int x, y;
  int media;
  char paleta[768];
  GetPal(paleta);

  for (x=0;x<768;x+=3)
  {
     media = (paleta[x] + paleta[x+1] + paleta[x+2]) / 3;
     pal[x] = media;
     pal[x+1] = media;
     pal[x+2] = media;
  }
}

/*-/-/-/-/-/-/-/-/-/-/-/-/ OTRAS FUNCIONES COMPLEMENTARIAS /-/-/-/-/-/-/-/-*/
void Outportb(int port, unsigned char dato)
{
 asm mov dx, [port]
 asm mov al, [dato]
 asm out dx, al
}

unsigned char Inportb(int port)
{
 asm mov dx, [port]
 asm in al, dx
 return _AL;
}

void WRetr()
{
 asm mov dx, 3DAh

et1:
 asm in  al,dx
 asm test al, 8
 asm jnz et1

et2:
 asm in  al,dx
 asm test al, 8
 asm jz  et2
}


