/* 
  ޳
  ޳ Gargon Software / Code by eXcalibur                                 ޳
  ޳                                                                     ޳
  ޳ Gargonscene n1. Efecto 'Campo de estrellas horizontal'.            ޳
  ޳ 1997, Gargon Soft.                                                  ޳
  ޳
*/
/*-.-.-.-.-.-.-.-.-.-.-.-... Librerias a incluir ...-.-.-.-.-.-.-.-.-.-.-.-.*/
#include <dos.h>                        /* pokeb()...                       */
#include <conio.h>                      /* kbhit()...                       */
#include <stdlib.h>                     /* randomize(), random()...         */

/*-.-.-.-.-.-.-.-.-.-.-.-... Constantes numricas ...-.-.-.-.-.-.-.-.-.-.-.-*/
#define GRAFICO         19              /* Modos grficos. (13h & 03h)      */
#define TEXTO           3                                                      

#define MAXSTARS        150             /* Maximo nmero de estrellas. Si   */
				/* quereis podes cambiarlas con    */
				/* cualquier otro nmero (no s'us   */
				/* paseis) ;)                       */

/*-.-.-.-.-.-.-.-.-.-... Declaracin de las funciones ...-.-.-.-.-.-.-.-.-.-*/
void WRetrace();
void IniMode(char mode);
void PutPixel(int x, int y, char Color);
void CambiaColor(char Color, char R, char G, char B);

/*-.-.-.-.-.-.-.-.-.-.-.-.-... Varibles Globales ...-.-.-.-.-.-.-.-.-.-.-.-.*/
struct Stars {                    /* Estructura que guarda la posicin*/
	     int x[MAXSTARS];   /* de las estrellas, su velocidad y */
	     int y[MAXSTARS];   /* color.                           */
	     int z[MAXSTARS];                                             
	   }Stars;

/*
  
   Inicio (main())                                                       
  
*/
void main()
{
 int i;                         /* Indice para bucles for           */

 IniMode(GRAFICO);                      /* Iniciamos Modo 13h               */
 randomize();                   /* Para que los nmeros aleatorios
				   no sean siempre los mismos ;)
				*/
 for(i=0;i<MAXSTARS;i++)                /* Creamos con random posiciones a- */
	{                       /* leatorias para las estrellas     */
	 Stars.x[i]=random(319);
	 Stars.y[i]=random(199);
	 Stars.z[i]=random(3)+1;
	}

 CambiaColor(1,30,30,30);               /* Cambiamos los colores 1, 2, 3 pa-*/
 CambiaColor(2,45,45,45);               /* ra la profundidad  de las  estre-*/
 CambiaColor(3,62,62,62);               /* llas entorno  a la velocidad  sea*/
				/* ms real.                        */

 do {                           /* Mientras no se pulse tecla...    */

     WRetrace();                        /* Esperamos retraz. (sincronizamos).
				   Si teneis un ordenador potente,  
				   lo seguramente el efecto os ir  
				   demasiado deprisa, bien, podemos 
				   sanar este 'fallo' esperando ms 
				   retrazados... ;)
				*/

     for(i=0;i<MAXSTARS;i++)            /* Dibujamos estrellas, y actualiza-*/
		{               /* mos posicin                     */
		 PutPixel(Stars.x[i], Stars.y[i], 0);  /* Borramos ante-*/
						 /* rior punto... */
		 Stars.x[i]=Stars.x[i]+Stars.z[i];     /* Actualizamos  */
						 /* posicin est. */
		 if(Stars.x[i]>320)              /* Si la estrella*/
			{                        /* se ha ido, ha-*/
			 Stars.x[i]=0;           /* cemos una nue-*/
			 Stars.y[i]=random(199);     /* va, pero x=0  */                                        
			 Stars.z[i]=random(3)+1;
			}         /* Ponemos estrella del color z     */
		 PutPixel(Stars.x[i], Stars.y[i], Stars.z[i]);
		}

    }while(!kbhit());

 IniMode(TEXTO);
 asm mov ax, 4c00h                      /* Interrupcin para acabar el pro- */
 asm int 21h                    /* grama, salir al dos ;)           */
}

/*
  
   Funcin void PutPixel(int x, int y, char Color);                      
  
   Rutina para poner un pixel en pantalla en modo 13h.                   
                                                                         
   x..... Pos. vertical pixel      Color...... Nm. de color (0-255)     
   y..... Pos. horizontal pixel                                          
  
*/
void PutPixel(int x, int y, char Color)
 {
  pokeb(0xA000, y*320+x, Color);      /* SEGMENTO:OFFSET (A000:Y*320+X) */
 }


/*
  
   Funcin void IniMode(char Mode);                                      
  
   Funcin que inicia un modo grfico.                                   
                                                           
   Entrada: GRAFICO...Mode 13h        TEXTO...Modo texto (80x25)         
  
*/
void IniMode(char mode)  
 {                          
  asm xor ax, ax
  asm mov al, mode
  asm int 10h
 }                            


/*
  
   Funcin void WRetrace(void);                                          
  
   Rutina que espera al retrazado vertical de la VGA.                    
                                                                         
   Esto lo conseguimos mediante el registro de la VGA Input Status Regis-
   ter 1, en la direccin del puerto 3DAh, que nos informa en su bit 3 la
   seal del retrazado vertical, de modo que podemos detectar si se  est
   efectuando en qualquier momento este. La rutina se espera a que el re-
   trace finalize, entonces continua.                                    
  
*/
void WRetrace()
 {

 asm  {
	 mov dx, 3DAh           /* Input Status Register 1          */
      }   
et1:
 asm  {
	 in  al,dx      
	 and al,8h     
	 jnz et1        
      } 
et2:
 asm  {
	 in  al,dx      
	 and al,8h     
	 jz  et2
				/* Finalizado retrazado vertical    */
      }
  /*
    Nota: Si queres emplear 'C puro', lo anterior se puede hacer de la sigui-
	ente manera empleando la intruccin inport() del ANSI C :

	while(!(inport(0x3da) & 8));            // Espera retrace 
  */
 }


/*
  
   Funcin void CambiaColor(char Color, char R, char G, char B);         
  
   Rutina para cambiar el valor de un color para obtener otro.           
                                                                         
   Utiliza primero el puerto 3C8h, poniedo en este el valor del color que
   queremos cambiar, todo seguido nos dipondremos a meter  los nuevos va-
   lores en el orden RGB (Rojo, Verde y Azul) en el puerto 3C9h.         
  
*/
void CambiaColor(char Color, char R, char G, char B)
 {                                    
  outportb(0x3c8,Color);                /* Color a cambiar                  */

  outportb(0x3c9,R);            /* Los cambiamos todo en el orden   */
  outportb(0x3c9,G);            /* R (Rojo), G (Verde), B (Azul)    */
  outportb(0x3c9,B);
 }
