#include <mytypes.h>
#include "modload.h"
#include "modplay.h"


ULONG far *patptr;		// pointer to the current pattern (first row)
ULONG far *rowptr;
UWORD patpos=0;
UWORD sngpos=0;
UWORD sngspd=6;
UWORD vbtick=5;
UWORD patbrk=1;

AUDTMP mp_audio[8];
UBYTE  mp_bpm=125;


UWORD VibratoTable[64]={
	0,24,49,74,97,120,141,161,
	180,197,212,224,235,244,250,253,
	255,253,250,244,235,224,212,197,
	180,161,141,120,97,74,49,24,

	0,-24,-49,-74,-97,-120,-141,-161,
	-180,-197,-212,-224,-235,-244,-250,-253,
	-255,-253,-250,-244,-235,-224,-212,-197,
	-180,-161,-141,-120,-97,-74,-49,-24
};


UWORD npertab[16][36]={

// -> Tuning 0
	856,808,762,720,678,640,604,570,538,508,480,453,
	428,404,381,360,339,320,302,285,269,254,240,226,
	214,202,190,180,170,160,151,143,135,127,120,113,
// -> Tuning 1
	850,802,757,715,674,637,601,567,535,505,477,450,
	425,401,379,357,337,318,300,284,268,253,239,225,
	213,201,189,179,169,159,150,142,134,126,119,113,
// -> Tuning 2
	844,796,752,709,670,632,597,563,532,502,474,447,
	422,398,376,355,335,316,298,282,266,251,237,224,
	211,199,188,177,167,158,149,141,133,125,118,112,
// -> Tuning 3
	838,791,746,704,665,628,592,559,528,498,470,444,
	419,395,373,352,332,314,296,280,264,249,235,222,
	209,198,187,176,166,157,148,140,132,125,118,111,
// -> Tuning 4
	832,785,741,699,660,623,588,555,524,495,467,441,
	416,392,370,350,330,312,294,278,262,247,233,220,
	208,196,185,175,165,156,147,139,131,124,117,110,
// -> Tuning 5
	826,779,736,694,655,619,584,551,520,491,463,437,
	413,390,368,347,328,309,292,276,260,245,232,219,
	206,195,184,174,164,155,146,138,130,123,116,109,
// -> Tuning 6
	820,774,730,689,651,614,580,547,516,487,460,434,
	410,387,365,345,325,307,290,274,258,244,230,217,
	205,193,183,172,163,154,145,137,129,122,115,109,
// -> Tuning 7
	814,768,725,684,646,610,575,543,513,484,457,431,
	407,384,363,342,323,305,288,272,256,242,228,216,
	204,192,181,171,161,152,144,136,128,121,114,108,
// -> Tuning -8
	907,856,808,762,720,678,640,604,570,538,508,480,
	453,428,404,381,360,339,320,302,285,269,254,240,
	226,214,202,190,180,170,160,151,143,135,127,120,
// -> Tuning -7
	900,850,802,757,715,675,636,601,567,535,505,477,
	450,425,401,379,357,337,318,300,284,268,253,238,
	225,212,200,189,179,169,159,150,142,134,126,119,
// -> Tuning -6
	894,844,796,752,709,670,632,597,563,532,502,474,
	447,422,398,376,355,335,316,298,282,266,251,237,
	223,211,199,188,177,167,158,149,141,133,125,118,
// -> Tuning -5
	887,838,791,746,704,665,628,592,559,528,498,470,
	444,419,395,373,352,332,314,296,280,264,249,235,
	222,209,198,187,176,166,157,148,140,132,125,118,
// -> Tuning -4
	881,832,785,741,699,660,623,588,555,524,494,467,
	441,416,392,370,350,330,312,294,278,262,247,233,
	220,208,196,185,175,165,156,147,139,131,123,117,
// -> Tuning -3
	875,826,779,736,694,655,619,584,551,520,491,463,
	437,413,390,368,347,328,309,292,276,260,245,232,
	219,206,195,184,174,164,155,146,138,130,123,116,
// -> Tuning -2
	868,820,774,730,689,651,614,580,547,516,487,460,
	434,410,387,365,345,325,307,290,274,258,244,230,
	217,205,193,183,172,163,154,145,137,129,122,115,
// -> Tuning -1
	862,814,768,725,684,646,610,575,543,513,484,457,
	431,407,384,363,342,323,305,288,272,256,242,228,
	216,203,192,181,171,161,152,144,136,128,121,114
};



void NewPatPtr(void)
{
	patpos=0;
	patptr=ml_patlist[ml_positions[sngpos++]];
	if(sngpos==ml_songlength) sngpos=0;
}



void DoEEffects(AUDTMP *a)
{
	UBYTE eff,dat,nib;

	eff=a->eff;
	dat=a->dat;
	nib=dat&0xf;

	switch(dat>>4){

		case 0x0:     						// filter toggle, not supported
				break;

		case 0x1:
				a->period-=nib;				// fineslide up
				eff=dat=0;
				break;

		case 0x2:
				a->period+=nib;				// fineslide dn
				eff=dat=0;
				break;

		case 0x3:       					// glissando ctrl, not yet
				break;

		case 0x4:       					// set vibrato waveform
				break;

		case 0x5:       					// set finetune
				break;

		case 0x6:       					// set patternloop
				break;

		case 0x7:       					// set tremolo waveform
				break;

		case 0x9:       					// retrig note
				break;

		case 0xa:                           // fine volume slide up
				a->volume+=nib;
				if(a->volume>64) a->volume=64;
				eff=dat=0;
				break;

		case 0xb:                           // fine volume slide dn
				a->volume-=nib;
				if(a->volume<0) a->volume=0;
				eff=dat=0;
				break;

		case 0xc:       					// cut note
				break;

		case 0xd:       					// note delay
				break;

		case 0xe:       					// pattern delay
				break;

		case 0xf:       					// invert loop, not supported
				break;
	}
	a->eff=eff;
	a->dat=dat;
}


void DoVibrato(AUDTMP *a)
{
	WORD temp;
	temp=VibratoTable[(a->vibpos>>2)&0x3f];
	temp*=a->vibdepth;
	temp>>=7;
	a->period=a->tperiod+temp;
	a->vibpos+=a->vibspd;
}


void DoVolSlide(AUDTMP *a)
{
	a->volume+=(a->dat>>4);        	// volume slide
	a->volume-=(a->dat&0xf);
	if(a->volume<0) a->volume=0;
	if(a->volume>64) a->volume=64;
}


void DoEffect(AUDTMP *a)
{
	UBYTE eff,dat,note;
	WORD temp;

	eff=a->eff;
	dat=a->dat;
	note=a->note;

	switch(eff){
		case 0x0:
				if(dat!=0){
					switch(vbtick%3){
						case 1:
							note+=(dat>>4); break;
						case 2:
							note+=(dat&0xf); break;
					}
					a->tperiod=npertab[ml_samples[a->sample].finetune&0xf][note];
				}
				break;

		case 0x1:
				if(dat!=0) a->portspeed=dat;
				a->tperiod-=a->portspeed;  				// portamento up
				break;

		case 0x2:
				if(dat!=0) a->portspeed=dat;
				a->tperiod+=a->portspeed;  				// portamento dn
				break;

		case 0x3:
				if(dat!=0) a->portspeed=dat;	// noteportamento
				if(a->period<a->tperiod){
					a->period+=a->portspeed;
					if(a->period>=a->tperiod){
						a->period=a->tperiod;
						eff=dat=0;
					}
				}
				else if(a->period>a->tperiod){
					a->period-=a->portspeed;
					if(a->period<=a->tperiod){
						a->period=a->tperiod;
						eff=dat=0;
					}
				}
				break;

		case 0x4:									// vibrato
				if(dat&0x0f) a->vibdepth=dat&0xf;
				if(dat&0xf0) a->vibspd=(dat&0xf0)>>2;
				dat=0;
				DoVibrato(a);
				break;

		case 0x9:
				a->start=(ULONG)dat<<8;		// set sampleoffset
				if(a->start>a->size) a->start=a->size;
				eff=dat=0;
				break;

		case 0x6:                      			// vibrato + volslide
				DoVibrato(a);
				DoVolSlide(a);
				break;

		case 0xa:               				// volume slide
				DoVolSlide(a);
				break;

		case 0xb:								// position jump
				sngpos=dat;
				if(sngpos>ml_songlength) sngpos=0;
				NewPatPtr();
				eff=dat=0;
				break;

		case 0xc:
				a->volume=dat;					// set volume
				eff=dat=0;
				break;

		case 0xd:
				patbrk=(dat & 63)+1;			// pattern break
				eff=dat=0;
				break;

		case 0xe:								// extended effects
				DoEEffects(a);
				eff=a->eff;
				dat=a->dat;
				break;

		case 0xf:
				if(dat<0x20){
					sngspd=dat;					// set speed
				}
				else{
					mp_bpm=dat;
				}
				eff=dat=0;
				break;

	}
	a->eff=eff;
	a->dat=dat;

	if(eff!=0x3 && eff!=0x4 && eff!=0x6) a->period=a->tperiod;
}




void PlayNote(UBYTE far *p,AUDTMP *aud)
{
	UBYTE d,b;

	d=p[0];
	b=p[1];

	aud->eff=p[2];
	aud->dat=p[3];

	if(d!=0){
		d--;
		aud->sample=d;
		aud->volume=ml_samples[d].volume;
		aud->size=ml_samples[d].length;

	}
	d=aud->sample;

	if(ml_samples[d].replen>2){
		aud->size=ml_samples[d].reppos+ml_samples[d].replen;
		aud->loop=ml_samples[d].reppos;
	}
	else
	aud->loop=ml_samples[d].length;

	if(b!=0){
		b--;

		aud->note=b;
		aud->tperiod=npertab[ml_samples[d].finetune&0xf][b];

		if(aud->eff==0x3) return;

		aud->kick=1;
		aud->start=0;
	}
}




void MP_HandleTick(void)
{
	int t;

	vbtick++;

	if(vbtick>=sngspd){

		// pattern break active ? -> do a patternbreak

		if(patbrk){
			NewPatPtr();
			patpos=patbrk-1;
			patbrk=0;
		}
		else if(patpos==64) NewPatPtr();

		rowptr=&patptr[patpos*ml_numchn];
		for(t=0;t<ml_numchn;t++){
			PlayNote((UBYTE far *)rowptr++,&mp_audio[t]);
		}
		patpos++;
		vbtick=0;
	}

	for(t=0;t<ml_numchn;t++){
		DoEffect(&mp_audio[t]);
	}
}


