#ifndef MODLOAD_H
#define MODLOAD_H

#include <stdio.h>
#include "mytypes.h"


#define MAX_PATTERNS	128
#define MAX_SAMPLES		31


typedef struct MSAMPINFO{	// sample header as it appears in a module
	UBYTE samplename[22];
	UWORD length;
	UBYTE finetune;
	UBYTE volume;
	UWORD reppos;
	UWORD replen;
} MSAMPINFO;


typedef struct SAMPLEINFO{	// new sample info with some converted types
	char  samplename[23];
	UBYTE finetune;
	UBYTE volume;
	ULONG length;
	ULONG reppos;
	ULONG replen;
} SAMPLEINFO;



typedef struct MODULEHEADER{
	UBYTE      songname[20];    		// the songname..
	MSAMPINFO  samples[31];				// all sampleinfo
	UBYTE      songlength;				// number of patterns used
	UBYTE      magic1;					// should be 127
	UBYTE      positions[128];			// which pattern to play at pos
	UBYTE      magic2[4];				// string "M.K." or "FLT4" or "FLT8"
} MODULEHEADER;


int	  ML_LoadModule(char *filename,FILE *ufp);
void  ML_RegisterSampleLoader(int (*Loader)(int samplenr,FILE *fp,ULONG size));


extern int ml_errno;				// last error number
extern char *ml_errlist[];			// list of error strings
extern int ml_numchn;				// number of channels in use
extern int ml_numpat;				// number of patterns used
extern int ml_numsmp;				// number of samples used
extern int ml_patsiz;				// size (bytecount) per pattern
extern char *ml_modtype;			// module type name
extern void far *ml_patlist[128];	// a list of all patterns
extern char ml_songname[21];		// 0-term songname string
extern UBYTE ml_songlength;			// songlength
extern UBYTE ml_positions[128];		// song sequence
extern SAMPLEINFO ml_samples[31];	// sample info


#endif
