#!/usr/bin/python
#
import sys
from signal import signal
from time import sleep
from random import Random
from math import pi

def angToRad(ang):
	#ang*2*3.14159/360
	#return ang*0.01745327
	return ang*pi/180.0
def radToAng(rad):
	#rad*360/(2pi)
	#return rad*57.2958279
	return rad*180.0/pi

#RobotOption codes
ROBOT_MAX_ROTATE           = '0'
ROBOT_CANNON_MAX_ROTATE    = '1'
ROBOT_RADAR_MAX_ROTATE     = '2'
ROBOT_MAX_ACCELERATION     = '3'
ROBOT_MIN_ACCELERATION     = '4'
ROBOT_START_ENERGY         = '5'
ROBOT_MAX_ENERGY           = '6'
ROBOT_ENERGY_LEVELS        = '7'
SHOT_SPEED                 = '8'
SHOT_MIN_ENERGY            = '9'
SHOT_MAX_ENERGY            = '10'
SHOT_ENERGY_INCREASE_SPEED = '11'
TIMEOUT                    = '12'
DEBUG_LEVEL                = '13'
SEND_ROBOT_COORDINATES     = '14'

#Radar object codes
NO_OBJECT  = '-1'
ROBOT       = '0'
SHOOT       = '1'
WALL        = '2'
COOKIE      = '3'
MINE        = '4'
LAST_OBJECT = '5'

#States of the robot
END     = 0    #bukatu
INIT    = 1    #hasieratzen
GENERAL = 2    #orokorra
HUNTING = 3    #robot jarrai
SCARED  = 4    #ihes
HUNGRY  = 5    #gaileta bila

class robot:
	def __init__(self):
		self.data={}
		self.data['name'] = 'Shagi'
		self.data['colour'] = 'ff0000'
		self.data['sleep_time'] = 0.3
		self.data['base_accel'] = 1
		self.data['accel_change'] = 0.05
		self.data['base_speed'] = 3
		self.data['speed_range'] = 0.15
		self.data['too_near'] = 3.0
		self.data['many_times'] = 10.0
		self.data['angular_velocity'] = 3.0
		self.data['damaged'] = 30
		self.data['bored'] = 10
		self.options={}
		self.radar_info={}
		self.rand = Random()
		self.initialize()
	def initialize(self):
		self.data['state'] = INIT
		self.data['accel'] = self.data['base_accel']
		self.data['sugested_speed'] = self.data['base_speed']
		self.data['turning'] = 0
		self.data['energy'] = 100.0
		self.data['time'] = 0.0
		self.data['shoot_history'] = [0.0, 0.0, 0.0]
		self.data['last_action'] = 0.0
		self.radar_info['wall_dist'] = 9999.0 #No wall viewed
		self.radar_info['wall_ang'] = 0.0     #
	def play(self):
		self.RobotOptions()
		while self.data['state']: #not state == END
			if self.radar_info['wall_dist']<self.data['too_near'] and not self.data['turning']:
				ang = self.rand.randrange(30,180)
				self.put("RotateAmount %d %d %d\n" % (1, -self.data['angular_velocity'], angToRad(ang)))
				self.data['turning'] = 1
				self.radar_info['wall_dist'] = 9999.0
			sleep(self.data['sleep_time'])
	
	def put(self,info):
		sys.stdout.write(info)
		sys.stdout.flush()

	def get(self):
		info = sys.stdin.readline()
		return info
	def parse(self):
		while 1:
			mezu = sys.stdin.readline()
			if len(mezu)==0:
				return
			info = mezu.split()
			if info[0][0] == 'C' and info[0][2] == 'l':    #Collision
				self.Collision(info[1],info[2])
			elif info[0][0] == 'C' and info[0][2] == 'o':  #Coordinates
				self.Coordinates(info[1],info[2],info[3])
			elif info[0][0] == 'D':                         #Dead
				self.Dead()
			elif info[0][:2] == 'En':                       #Energy
				self.Energy(info[1])
			elif info[0][:2] == 'Ex':                       #ExitRobot
				self.ExitRobot()
			elif info[0][0] == 'G' and info[0][4] == 'F':  #GameFinishes
				self.GameFinishes()
			elif info[0][0] == 'G' and info[0][4] == 'O':  #GameOption
				self.GameOption(info[1],info[2])
			elif info[0][0] == 'G' and info[0][4] == 'S':  #GameStarts
				self.GameStarts()
			elif info[0][0] == 'I' and info[0][2] == 'f':  #Info
				self.Info(info[1],info[2],info[3])
			elif info[0][0] == 'I' and info[0][2] == 'i':  #Initialize
				self.Initialize(info[1])
			elif info[0][:2] == 'Ra':                       #Radar
				self.Radar(info[1],info[2],info[3])
			elif info[0][0] == 'R' and info[0][5] == 'I':  #RobotInfo
				self.RobotInfo(info[1],info[2])
			elif info[0][0] == 'R' and info[0][2] == 't':  #RotationReached
				self.RotationReached(info[1])
			elif info[0][0] == 'R' and info[0][5] == 's':  #RobotsLeft
				self.RobotsLeft(info[1])
			elif info[0][0] == 'W':                        #Warning
				self.Warning(info[1],info[2])
			elif info[0][0] == 'Y' and info[0][4] == 'C':  #YourColour
				self.YourColour(info[1])
			elif info[0][0] == 'Y' and info[0][4] == 'N':  #YourName
				self.YourName(info[1])

	def Collision(self,objetua, ang):
		self.data['shoot_history'].append(self.data['time'])
		self.data['shoot_history'] = self.data['shoot_history'][1:]
		if (self.data['shoot_history'][2] - self.data['shoot_history'][0]) < self.data['many_times']:
			self.put('Debug SCARED!\n')
			self.data['state'] = SCARED
		pass
	def Coordinates(self,x,y,ang):
		pass
	def Dead(self):
		self.data['state'] = INIT
	def Energy(self,value):
		self.data['energy'] = float(value)
		if self.data['energy'] < self.data['damaged']:
			self.put('Debug Damaged!\n')
			self.data['state'] = HUNGRY
	def ExitRobot(self):
		self.data['state'] = END
	def GameFinishes(self):
		self.data['state'] = INIT
	def GameOption(self,type,value):
		self.options[type] = float(value)
	def GameStarts(self):
		self.data['state'] = GENERAL
		self.put('Accelerate %d\n' % self.data['base_accel'])
		self.put('Sweep %d %d %d %d\n' % (6, 9999, angToRad(-90), angToRad(90)))
	def Info(self,time,speed,canon_ang):
		#self.put('Debug Info: %s %s %s\n' % (time, speed, canon_ang))
		self.data['time'] = float(time)
		if (self.data['time'] - self.data['last_action']) > self .data['bored']:
			self.put('Debug Azpertu nahiz...\n')
			self.data['state'] = GENERAL
		if self.data['speed_range']<self.data['sugested_speed']-float(speed): #too slow
			self.data['accel'] += self.data['accel_change']
			self.put('Accelerate %d\n' % self.data['accel'])
		elif -self.data['speed_range']>self.data['sugested_speed']-float(speed): #too slow
			self.data['accel'] -= self.data['accel_change']
			self.put('Accelerate %d\n' % self.data['accel'])
		#pass
	def Initialize(self,value):
		if value == '1':
			self.put('Name %s\n' % self.data['name'])
			self.put('Colour %s\n' % self.data['colour'])
	def Radar(self,dist,type,ang):
		if type == WALL:
			self.radar_info['wall_dist'] = float(dist)
			self.radar_info['wall_ang'] = radToAng(float(ang))
		elif type == MINE:
			if self.data['state'] == SCARED:
				self.put('Shoot %d\n' % self.options[SHOT_MIN_ENERGY])
			elif float(dist)<self.data['too_near']:
				self.put('Shoot %d\n' % self.options[SHOT_MIN_ENERGY])
		elif type == ROBOT:
			self.data['last_action'] = self.data['time']
			if self.data['state'] == GENERAL:
				self.put('Debug GENERAL Robot ikusia-> HUNTING\n')
				self.data['state'] = HUNTING
				self.put('Shoot %d\n' % self.options[SHOT_MAX_ENERGY])
			elif self.data['state'] == HUNTING:
				self.put('Debug HUNTING!\n')
				self.put('Shoot %d\n' % self.options[SHOT_MAX_ENERGY])
			elif self.data['state'] == SCARED: #Biratu
				self.put('Debug SCARED Robot ikusia -> Biratu\n')
				ang = self.rand.randrange(30,180)
				self.put("RotateAmount %d %d %d\n" % (1, self.data['angular_velocity'], angToRad(ang))) 
			elif self.data['state'] == HUNGRY: #Tiro eta biratu
				self.put('Debug HUNGRY Robot ikusia -> Tiro eta biratu\n')
				self.put('Shoot %d\n' % self.options[SHOT_MAX_ENERGY])
				ang = self.rand.randrange(30,180)
				self.put("RotateAmount %d %d %d\n" % (1, self.data['angular_velocity'], angToRad(ang))) 
		elif type == COOKIE:
			if self.data['state'] in  (GENERAL, HUNTING):
				if float(dist)>self.data['too_near']:
					self.put("Shoot %d\n" % self.options[SHOT_MIN_ENERGY])
	def RobotInfo(self,energia,taldekoa):
		pass
	def RotationReached(self,type):
		if type in ('1', '3', '5', '7'):
			self.data['turning'] = 0
	def RobotsLeft(self,zenbat):
		pass
	def Warning(self,type,info):
		self.put('Debug Warning: %s %s\n' % (type,info))
	def YourColour(self,colour):
		self.data['colour'] = colour
	def YourName(self,name):
		self.data['name'] = name
	def RobotOptions(self):
		self.put("RobotOption 0 1\n")           #SEND_SIGNAL = 1
		self.put("RobotOption 1 2\n")		#SEND_ROTATION_REACHED always
		self.put("RobotOption 2 10\n")		#SIGNAL = SIGUSR1

robota = robot()
def handler (signum, frame):
	robota.parse()
signal(10,handler)
robota.play()

