
#include <iostream.h>
#include <unistd.h>
#include <signal.h>
#include <stdlib.h>
#include <math.h>
#include <realtimebattle/Messagetypes.h>

int mens = 0;
int quieto = 2;
int impacto = 0;
int sweep = 50;
double tid, speed, radar_angle, cannon_angle;
int robots_left = 20;
int tics = 5;
volatile sig_atomic_t exit_robot = false;
volatile sig_atomic_t warmode = true;
volatile sig_atomic_t collision_mode = false;
volatile sig_atomic_t normal_mode = false;
int colision_mode = 0;
double dist_aux = 15;
double energy;

message_to_robot_type
name2msg_to_robot_type(char* msg_name)
{
	for(int i=0; message_to_robot[i].msg[0] != '\0'; i++)
	{
		if( strcmp(message_to_robot[i].msg, msg_name) == 0 )
			return (message_to_robot_type)i;
	}
	return UNKNOWN_MESSAGE_TO_ROBOT;
}

void
check_messages(int sig)
{
	message_to_robot_type msg_t;
	char msg_name[81];
	exit_robot = false;
	cin.clear();
	while( !cin.eof() )
	{
		cin >> msg_name;
		msg_t = name2msg_to_robot_type(msg_name);
		mens++;
			
		switch(msg_t)
		{
			case GAME_FINISHES:
				break;
			case DEAD:
				break;
			case GAME_STARTS:
				break;
			
			case EXIT_ROBOT:
				cout << "Print Bye!" << endl;
				exit_robot = true;
				break;
			case INITIALIZE:
				int init;
				cin >> init ;
				if (init == 1)
				{
					cout << "Name Motxilo" << endl;
					cout << "Colour aaaaaa ffffff" << endl;                                      
				}
				break;

			case INFO:
				if (quieto > 1)
       				{
                			cout << "Brakes " << 0.0 << endl;
                			if (quieto == 1)
					cout << "Accelerate 1.0 " << endl;
					quieto--;
				} 
				cin >> tid >> speed  >> cannon_angle;
				cout << "Print INFO " << endl;
				tics--;
                                if ( tics < 0 )
                                {
					warmode = false;
					normal_mode = true;
					tics = 5;
                                }
                                break; 
			case ROBOTS_LEFT:
				cin >> robots_left;
				cout << "Print Mucho Macho!" << endl;
				break; 
			case RADAR:
			{	double dist;
				
				int object;
				cin >> dist >> object >> radar_angle;
				switch(object)
				{	
					case 0: 
						cout << "Accelerate 1" << endl;
						impacto = 0;
						collision_mode = false;
						dist_aux = dist;
						warmode = true;
						normal_mode = false;
                                                
						cout << "RotateAmount 1 10 " << radar_angle << endl;
                                                cout << "RotateTo 6 10 0"  << endl;                                                        
                                                break;
					case 1:
						cout << "Accelerate 1" << endl;
						if (collision_mode)
     					{
							impacto = 0;
							collision_mode = false;
							dist_aux = dist;
							warmode = true;
							normal_mode = false;
							cout << "RotateAmount 1 10 " << radar_angle << endl;
                            cout << "RotateTo 6 10 0"  << endl;                                                        
                        }        
						break;

					case 2:
                                                if (warmode)
						break;
						if (dist < 5.5) //6
						{
						cout << "Accelerate 0.0" << endl;  
						quieto =100; //20
						cout << "Brake 1.0 " << endl;
                                                cout << "RotateAmount 1 10 " << endl; //10..5
                                                }
						break;
					}
				if (warmode)
				break;
				switch(object)
				{	
					

					case 3:
						cout << "Accelerate 1" << endl;
               					cout << "RotateAmount 1 10 " << radar_angle << endl;
                                                cout << "RotateTo 6 10 0"  << endl;                                                        
	       	                                break; 
					case 4:
                                              	cout << "Shoot " << 1.0 << endl;
                                                break;
				}
				break;
			}
			case COLLISION:
			{
				int tmp;
				double coll_angle;
				cin >> tmp >> coll_angle;
				switch(tmp)
				{
					case 0: 
						quieto = 15; //15..10
						cout << "Accelerate 0.0" << endl;  
                        cout << "Brakes 1.0 "  << endl;
						if (warmode)
						break;
						collision_mode=true;
					//	warmode = true;
                                                
					break;

					case 1:
						impacto++;
						if (impacto > 1) // 2
						{
						collision_mode =true;
						}		
//funcionamiento normal
					        quieto = 10; //10..5
						cout << "Print me acaban de meter un tiro por el culo " << endl;
					   	cout << "Brakes 1.0 "  << endl;
                                                break;
						if (warmode)
						{
						tics = 15;
						break;
						}
						warmode = true;
						collision_mode = true;
						break;
					case MINE:
						quieto = 2;
						break;
					case 2:
						quieto = 20; //20..10
						break;
				}
			}
				break;
			default:
				break;
		}
	}	
	signal (sig, check_messages);
}

int 
main(int argc, char * argv[])
{

	signal(SIGUSR1, check_messages);
	cout << "RobotOption " << SIGNAL << " " << SIGUSR1 << endl;	
	for(;;sleep(1))
	{
		if (normal_mode)
			cout << "Sweep 6 10 -0.5 0.5" << endl;
			
		if (warmode)
			cout << "Shoot " << SHOT_MAX_ENERGY << endl; 
			
		if (collision_mode )
			cout << "Rotate 7 10 " << endl; //20..10
			
		if( exit_robot ) 
			return(EXIT_SUCCESS);
	}
	return(EXIT_SUCCESS);
}
