/*
DivOlution, un robot para RealTimeBattle
Copyright (C) 2003  Dives

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <math.h>
#include <string.h>

#include "dives.hh"

#define abs(x) ((x>0) ? (x) : -(x))


bool enemigo = false;
int enemigo2 = 30;		// hace cuanto que has visto al enemigo
volatile sig_atomic_t exitRobot = false;
GAMEOPTION gopt;
DATOSROBOT drob;


// Enva nombre y color si es la primera sequencia
void initialize( const int first_seq )
{
	if( first_seq == 1 )
	{
		name( "DivOlution" );
		colour( "dddddd", "eeeeee" );
	}
}

// Resetea el robot cuando empieza un nuevo juego
void game_starts()
{  
	sweep( RCANNON+RRADAR, M_PI/2.0, -M_PI/2.0, M_PI/2.0 );
	drob.robot_rotate = 0.0;
	drob.slumprotate = 1.0;
	drob.maxspeed = 10.0;
	drob.robotsLeft = 20;
	drob.acceleration = 0.2;
	accelerate( drob.acceleration );
	/******************************************************************/
}

// El juego ha terminado
void game_finishes()
{
	/******************************************************************/
}

// Recibe informacin sobre tiempo, velocidad y ngulo del can
void info( const double tiempo, const double speed, const double cannon_angle )
{
	if (++enemigo2 > 100)
		enemigo2 = 30;

	if (enemigo2 < 30)
	{
		double energy = 20.0/drob.robotsLeft;
		shoot( energy );
	}
		
	cout << "Print " << enemigo2 << endl;
	drob.speed = speed;
	drob.cannon_angle = cannon_angle;
	if(rand() < (RAND_MAX/500))
	{
		drob.slumprotate = 0.0;
		while (abs(drob.slumprotate) < 0.5)
			drob.slumprotate = ((double)(rand())/(double)RAND_MAX-0.5)*2.0;
	}
	/******************************************************************/
}

// Cuantos robots quedan en el juego
void robots_left( const int number_of_robots )
{
	drob.robotsLeft = number_of_robots;
}

// Radar: informacin cuando se ve un robot
void radar_robot( const double dist, const double angulo )
{
	enemigo = true;
	enemigo2 = 0;
	double energy = 20.0/(dist*dist+0.2)+0.5+2.0/double(drob.robotsLeft);
	drob.robot_rotate = M_PI/3.0;
	if (dist < 3.0)
	{
		drob.acceleration = 2.0;
	}
	else
	{
		if (drob.speed < drob.maxspeed)
			drob.acceleration = 2.0;
		else
			drob.acceleration = 0.0;
	}
	rotate_amount( RROBOT, drob.robot_rotate, angulo );
	rotate_to( RCANNON+RRADAR, -drob.robot_rotate, 0.0);
	//rotate_to( RCANNON+RRADAR, drob.robot_rotate, angulo);
	shoot( energy );
	accelerate( drob.acceleration );
	/******************************************************************/
}

// Radar: informacin cuando se ve una pared
void radar_wall( const double dist, const double angulo )
{
	if (enemigo2 < 30)
		return;
	if (enemigo)
	{
		sweep( RCANNON+RRADAR, M_PI/2.0, -M_PI/6.0, M_PI/6.0 );
		enemigo = false;
		drob.slumprotate = -drob.slumprotate;
	}
	if( dist < 1.0 )
	{
		sweep( RCANNON+RRADAR, M_PI/2.0, -M_PI/2.0, M_PI/2.0 );
		if (drob.speed > 0.1)
		{
			drob.acceleration = 0.0;
			drob.robot_rotate = 0.0;
			brake( 1 );
		}
		else
		{
			drob.robot_rotate = 5.0*drob.slumprotate;
			drob.acceleration = 0.1;
		}
	}
	else
	{
		if (dist < 4.0)
		{
			if (drob.speed > 2.0)
			{
				drob.acceleration = 0.0 ;
				drob.robot_rotate = 2.0*drob.slumprotate ;
				brake( 0.7 );
			}
			else
			{
				drob.acceleration = 0.1;
				drob.robot_rotate = 1.0*drob.slumprotate;
			}
		}
		else
		{
			drob.robot_rotate = 0.3*drob.slumprotate;
			if (drob.speed < drob.maxspeed)
				drob.acceleration = 2.0;
			else
				drob.acceleration = 0.0;
		}
	}
	rotate( RROBOT, drob.robot_rotate );
	accelerate( drob.acceleration );
	/******************************************************************/
}

// Radar: informacin cuando se ve un disparo
void radar_shot( const double dist, const double angulo )
{
	if (enemigo2 < 30)
		return;

	if (drob.speed < 1.0)
	{
		drob.acceleration = 2.0;
		drob.robot_rotate = 1.0*drob.slumprotate;
	}
	else
		drob.robot_rotate = 3.0*drob.slumprotate;

	accelerate( drob.acceleration );
	rotate( RROBOT, drob.robot_rotate );
	/******************************************************************/
}

// Radar: informacin cuando se ve una galleta
void radar_cookie( const double dist, const double angulo )
{
	drob.robot_rotate = 0.0;
	if (drob.speed < 3.0)
		drob.acceleration = 2.0;
	else
		drob.acceleration = 0.0;

	rotate( RROBOT, drob.robot_rotate );
	accelerate( drob.acceleration );
	/******************************************************************/
}

// Radar: informacin cuando se ve una mina
void radar_mine( const double dist, const double angulo )
{
	if (dist < 10)
	{
		drob.acceleration = 0.0;
		drob.robot_rotate = 2.0*drob.slumprotate;
		if (drob.speed > 0.4)
			brake( 1 );

		shoot( 0.5 );
		accelerate( drob.acceleration );
		rotate( RROBOT, drob.robot_rotate );
	}
	/******************************************************************/
}

// Colisin contra otro robot
void collision_robot( const double angulo )
{
	if (enemigo2 < 30)
		return;

	//double energy_diff = 0;

	if (abs(angulo) < M_PI/6.0) // && energy_diff < 5)
		drob.acceleration = 2.0;
	else
	{
		drob.acceleration = -0.5;
		drob.robot_rotate = 5.0*drob.slumprotate;
	}

	accelerate( drob.acceleration );
	rotate( RROBOT, drob.robot_rotate );
	/******************************************************************/
}

// Colisin contra una pared
void collision_wall( const double angulo )
{
	drob.acceleration = 0.0;
	accelerate( drob.acceleration );
	/******************************************************************/
}

// Colisin contra un disparo
void collision_shot( const double angulo )
{
	if (enemigo2 < 30)
		return;

	if (abs(angulo) < M_PI/4.0)
	{
		if(drob.speed < 3.0)
			drob.acceleration = 2.0;
		else
			drob.acceleration = 0.0;

		drob.robot_rotate = 5.0*drob.slumprotate;
	}
	rotate( RROBOT, drob.robot_rotate );
	accelerate( drob.acceleration );
	/******************************************************************/
}

// Colisin contra una galleta
void collision_cookie( const double angulo )
{
	//print( "Una deliciosa galletita! :)" );
}

// Colisin contra una mina
void collision_mine( const double angulo )
{
	//print( "Mier**! Una mina! :(" );
}

// Mensaje de advertencia
void warning( const int tipo, const char* men )
{
	char mensaje[200];

	switch( tipo )
	{
		case UNKNOWN_MESSAGE:
			strcpy( mensaje, "Unknown message: " );
			break;
		case PROCESS_TIME_LOW:
			strcpy( mensaje, "Process time low: " );
			break;
		case MESSAGE_SENT_IN_ILLEGAL_STATE:
			strcpy( mensaje, "Message sent in illegal state: " );
			break;
		case UNKNOWN_OPTION:
			strcpy( mensaje, "Unknown option: " );
			break;
		case OBSOLETE_KEYWORD:
			strcpy( mensaje, "Obsolete Keyword: " );
			break;
	}
	strcat( mensaje, men );
	print( mensaje );
}

// Hay que sacar el robot
void exit_robot()
{
	print( "Me voy, hasta luego!" );
	exitRobot = true;
}

// El nombre que el robot tiene en el juego
void your_name( const char* prev_name )
{
	/******************************************************************/
}

// El color que el robot tiene en el juego
void your_colour( const char* color )
{
	/******************************************************************/
}

// Recibe datos de una opcin del juego
void game_option( const int opcion, const double valor )
{
	switch( opcion )
	{
		case ROBOT_MAX_ROTATE:
			gopt.robot_max_rotate = valor;
			break;
		case ROBOT_CANNON_MAX_ROTATE:
			gopt.robot_cannon_max_rotate = valor;
			break;
		case ROBOT_RADAR_MAX_ROTATE:
			gopt.robot_radar_max_rotate = valor;
			break;
		case ROBOT_MAX_ACCELERATION:
			gopt.robot_max_acceleration = valor;
			break;
		case ROBOT_MIN_ACCELERATION:
			gopt.robot_min_acceleration = valor;
			break;
		case ROBOT_START_ENERGY:
			gopt.robot_start_energy = valor;
			break;
		case ROBOT_MAX_ENERGY:
			gopt.robot_max_energy = valor;
			break;
		case ROBOT_ENERGY_LEVELS:
			gopt.robot_energy_levels = valor;
			break;
		case SHOT_SPEED:
			gopt.shot_speed = valor;
			break;
		case SHOT_MIN_ENERGY:
			gopt.shot_min_energy = valor;
			break;
		case SHOT_MAX_ENERGY:
			gopt.shot_max_energy = valor;
			break;
		case SHOT_ENERGY_INCREASE_SPEED:
			gopt.shot_energy_increase_speed = valor;
			break;
		case TIMEOUT:
			gopt.timeout = valor;
			break;
		case DEBUG_LEVEL:
			gopt.debug_level = valor;
			break;
		case SEND_ROBOT_COORDINATES:
			gopt.send_robot_coordinates = (int)rint(valor);
			break;
	}
}

// Informacin sobre la posicin del robot.
// Las coordenadas pueden ser absolutas, relativas a la posicin de comienzo,
// o nada, dependiendo de la opcin SEND_ROBOT_COORDINATES.
void coordinates( const double x, const double y, const double rotacion)
{/*
	if( gopt.send_robot_coordinates == 0 )
		return;

	current_x_coordinate = x;
	current_y_coordinate = y;
	current_robot_angle = rotacion;*/
	/******************************************************************/
}

// Informacin sobre el robot avistado
void robot_info( const double energia, int enemigo )
{
	/******************************************************************/
}

// Cuando un giro ha concluido
void rotation_reached( const int que )
{/*
	if( what & 1 == 1 )
	{
		rotate_allowed = true;
		acceleration_change_allowed = true;
		int direction = rand() / (RAND_MAX/2);
		if( direction == 0 ) direction = -1;
		drob.robot_rotate = 0.53 * direction;
		drob.acceleration = 1.0;
		accelerate( drob.acceleration );
	}*/
	/******************************************************************/
}

// El nivel de energa del robot
void energy( const double nivEnergia )
{
	/******************************************************************/
}

// El robot est muerto
void dead()
{
	/******************************************************************/
}
