/*
DivOlution, un robot para RealTimeBattle
Copyright (C) 2003  Dives

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "dives.hh"

void robot_option( const int opcion, const int valor )
{
	cout << "RobotOption " << opcion << " " << valor << endl;
}

void name( const char* nombre )
{
	cout << "Name " << nombre << endl;
}

void colour( const char* casa, const char* fuera )
{
	cout << "Colour " << casa << " " << fuera << endl;
}

void rotate( const int que, const double vel )
{
	cout << "Rotate " << que << " " << vel << endl;
}

void rotate_to( const int que, const double vel, const double angulo )
{
	cout << "RotateTo " << que << " " << vel << " " << angulo << endl;
}

void rotate_amount( const int que, const double vel, const double angulo )
{
	cout << "RotateAmount " << que << " " << vel << " " << angulo << endl;
}

void sweep( const int que, const double vel, const double izda, const double dcha )
{
	cout << "Sweep " << que << " " << vel << " " << izda << " " << dcha << endl;
}

void accelerate( const double cantidad )
{
	cout << "Accelerate " << cantidad << endl;
}

void brake( const double cantidad )
{
	cout << "Brake " << cantidad << endl;
}

void shoot( const double energia )
{
	cout << "Shoot " << energia << endl;
}

void print( const char* mensaje )
{
	cout << "Print " << mensaje << endl;
}

void debug( const char* mensaje )
{
	cout << "Debug " << mensaje << endl;
}

void debug_line( const double start_angle, const double start_radius,
										const double end_angle, const double end_radius )
{
	cout << "DebugLine " << start_angle << " " << start_radius << " "
												<< end_angle << " " << end_radius << endl;
}

void debug_circle( const double center_angle, const double center_radius,
																	const double circle_radius )
{
	cout << "DebugCircle " << center_angle << " " << center_radius << " "
																		<< circle_radius << endl;
}
