/*
DivOlution, un robot para RealTimeBattle
Copyright (C) 2003  Dives

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream.h>
#include <stdlib.h>
#include <signal.h>

#include "Messagetypes.h"


#define RROBOT  1 // rotate Robot
#define RCANNON 2 // rotate Cannon
#define RRADAR  4 // rotate Radar


struct game_option
{
	double robot_max_rotate;
	double robot_cannon_max_rotate;
	double robot_radar_max_rotate;
	double robot_max_acceleration;
	double robot_min_acceleration;
	double robot_start_energy;
	double robot_max_energy;
	double robot_energy_levels;
	double shot_speed;
	double shot_min_energy;
	double shot_max_energy;
	double shot_energy_increase_speed;
	double timeout;
	double debug_level;
	int    send_robot_coordinates;
};


struct datos_robot
{
	//char*  robot_name;
	//char*  robot_colour;
	double acceleration;
	double robot_rotate;
	//double radar_rotate;
	//double cannon_rotate;
	//double radar_angle;
	double cannon_angle;
	double speed;
	double maxspeed;
	double slumprotate;
	//double brake_value;
	//int    shots_hit;
	//double last_shot_hit_time;
	//double current_time;
	//double current_x_coordinate;
	//double current_y_coordinate;
	//double current_robot_angle;
	int    robotsLeft;
};


typedef struct game_option GAMEOPTION;
typedef struct datos_robot DATOSROBOT;


void robot_option( const int option, const int value );
void name( const char* name );
void colour( const char* home, const char* away );
void rotate( const int what, const double vel );
void rotate_to( const int what, const double vel, const double angle );
void rotate_amount( const int what, const double vel, const double angle );
void sweep( const int what, const double vel,
											const double left, const double right );
void accelerate( const double amount );
void brake( const double amount );
void shoot( const double energy );
void print( const char* message );
void debug( const char* message );
void debug_line( const double start_angle, const double start_radius,
									const double end_angle, const double end_radius );
void debug_circle( const double center_angle, const double center_radius,
									const double circle_radius );

/*****************************************************************************/

void initialize( const int first_seq );
void your_name( const char* prev_name );
void your_colour( const char* colour );
void game_option( const int option, const double value );
void game_starts();
void radar_robot( const double dist, const double angle );
void radar_shot( const double dist, const double angle );
void radar_wall( const double dist, const double angle );
void radar_cookie( const double dist, const double angle );
void radar_mine( const double dist, const double angle );
void coordinates( const double x, const double y, const double rotation);
void info( const double time, const double speed, const double cannon_angle );
void robot_info( const double energy, int enemy );
void rotation_reached( const int what );
void energy( const double energylevel );
void robots_left( const int number_of_robots );
void collision_robot( const double angle );
void collision_shot( const double angle );
void collision_wall( const double angle );
void collision_cookie( const double angle );
void collision_mine( const double angle );
void warning( const int type, const char* message );
void dead();
void game_finishes();
void exit_robot();
message_to_robot_type name2msg_to_robot_type(char* msg_name);
void check_messages(int sig);
