/*
DivOlution, un robot para RealTimeBattle
Copyright (C) 2003  Dives

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

//#ifdef TIME_WITH_SYS_TIME 
//# include <sys/time.h>
//# include <time.h>
//#else
//# if HAVE_SYS_TIME_H
//#  include <sys/time.h>
//# else
//#  include <time.h>
//# endif
//#endif

#include <unistd.h>

#include "Messagetypes.h"

#include "dives.hh"


extern volatile sig_atomic_t exitRobot;


// Pasa del mensaje de texto al tipo de mensaje
message_to_robot_type name2msg_to_robot_type(char* msg_name)
{
	for(int i=0; message_to_robot[i].msg[0] != '\0'; i++)
	{
		if( strcmp(message_to_robot[i].msg, msg_name) == 0 )
			return (message_to_robot_type)i;
	}
	return UNKNOWN_MESSAGE_TO_ROBOT;
}

// Determina el mensaje que llega
void check_messages(int sig)
{
	exitRobot = false;

	char msg_name[81];
	char text[81];
	message_to_robot_type msg_t;

	/*timeval current_time;
	gettimeofday(&current_time, NULL);
	srand(current_time.tv_usec);*/

	cin.clear();
	while( !cin.eof() )
	{
		cin >> msg_name;
		msg_t = name2msg_to_robot_type(msg_name);
		switch(msg_t)
		{
			case INITIALIZE:
				int init;
				cin >> init ;
				initialize( init );
				break;

			case GAME_STARTS:
				//          cout << "Rotate 1 " << drob.robot_rotate << endl;
				game_starts();
				break;

			case GAME_FINISHES:
				game_finishes();
				break;

			case INFO:
				double tiempo, vel, angulo;
				cin >> tiempo >> vel  >> angulo;
				info( tiempo, vel, angulo );
				break;

			case ROBOTS_LEFT:
				int robotsQuedan;
				cin >> robotsQuedan;
				robots_left( robotsQuedan );
				break;

			case RADAR:
			{
				double dist, angulo;
				int objeto;

				cin >> dist >> objeto >> angulo;
				switch(objeto)
				{
					case ROBOT:
						radar_robot( dist, angulo );
						//cout << "Print kill" << endl;
						break;
					case WALL:
						radar_wall( dist, angulo );
						break;
					case SHOT:
						radar_shot( dist, angulo );
						break;
					case COOKIE:
						radar_cookie( dist, angulo );
						break;
					case MINE:
						radar_mine( dist, angulo );
						break;
				}
				break;
			}

			case COLLISION:
			{
				int objeto;
				double angulo;
				cin >> objeto >> angulo;
				switch(objeto)
				{
					case ROBOT:
						collision_robot( angulo );
						break;
					case WALL:
						collision_wall( angulo );
						break;
					case SHOT:
						collision_shot( angulo );
						break;
					case COOKIE:
						collision_cookie( angulo ); 
						break;
					case MINE:
						collision_mine( angulo ); 
						break;
				}
				//if( enegry_diff != 0 ) cout << "Print energy changed by "
				// << enegry_diff << endl;
			}
			break;

			case WARNING:
				int type;
				char text[81];
				cin >> type;
				cin.getline(text, 80, '\n');
				warning( type, text );
				break;

			case EXIT_ROBOT:
				exit_robot();
				break;

			case YOUR_NAME:
				char nombre[81];
				cin >> nombre;
				your_name( nombre );
				break;

			case YOUR_COLOUR:
				char col[81];
				cin >> col;
				your_colour( col );
				break;

			case GAME_OPTION:
				int nr;
				double valor;
				cin >> nr >> valor;
				game_option( nr, valor );
				break;

			case COORDINATES:
				double x, y, rotacion;
				cin >> x >> y >> rotacion;
				coordinates( x, y, rotacion );
				break;

			case ROBOT_INFO:
				double energia;
				int enemigo;
				cin >> energia >> enemigo;
				robot_info( energia, enemigo );
				break;

			case ROTATION_REACHED:
				int que;
				cin >> que;
				rotation_reached( que );
				break;

			case ENERGY:
				double en;
				cin >> en;
				energy( en );
				break;

			case DEAD:
				dead();
				break;

			default:
				break;
		}
	}
	signal (sig, check_messages);
}

int main(int argc, char * argv[])
{
	sigset_t usr1set;

	//drob.robot_rotate = 0.53;


	//check_messages(SIGUSR1);
	signal(SIGUSR1, check_messages);

	// libpthread seems to block USR1 sometimes for some reason
	sigemptyset(&usr1set);
	sigaddset(&usr1set, SIGUSR1);
	sigprocmask(SIG_UNBLOCK, &usr1set, NULL);

	robot_option( SIGNAL, SIGUSR1);

	for(;;sleep(1))
	{
		if( exitRobot )
		{
			//          cerr << "Fire: Exiting normally!" << endl;
			return(EXIT_SUCCESS);
		}
	}
	return(EXIT_SUCCESS);
}
