/*
  Copyright (c) 2002 David Moreno Montero


  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.

*/

#include <realtimebattle/Messagetypes.h>
#include <iostream.h>
#include <string>
#include <unistd.h>
#include <time.h>
#include <math.h>

using namespace std;

double options[15];

///  Radar
double radarDistance=0;
int radarObject=NOOBJECT;
int lastRadarObject=NOOBJECT;
double radarAngle=0;
double lastRadarDistance=0;
/// Info
double robotTime=0;
double speed=0;
double cannonAngle=0;

/// Energy
double energy=100;

/// RobotInfo
double otherEnergy=0;
bool otherTeamMate=false;

/// Collision
bool colliding;
int collidingObject;
double collidingAngle;

int nAttack=0;

void Action();

int main(int argc, char **argv){
  string str;
  bool quit=false;
  int i;
  for (i=0;i<15;i++)
	 options[i]=0;

  nAttack=time(NULL);

  cout << "RobotOption " << USE_NON_BLOCKING << " " << 0 << endl;

  while(!quit){
    fsync(0);
    cin >>str;
    if (str=="Initialize"){
      cerr <<"Inicializando!"<<endl;
      int n;
      cin >>n;
      if (n==1){ // Mando color y nombre
	cout <<"Name CojoPitufo"<<endl;
	cout <<"Colour 1F1FFF FF00FF"<<endl;
      }
    }
    else if (str=="GameOption"){
      int n; double v;
      cin >>n>>v;
      if (n<15&&n>=0)
	options[n]=v;
    }
    else if (str=="ExitRobot")
      quit=true;
    else if (str=="GameStarts")
      continue;
    else if (str=="Radar"){
      cin >>radarDistance>>radarObject>>radarAngle;
    }
    else if (str=="Info"){
      cin >>robotTime>>speed>>cannonAngle;
    }
    else if (str=="RobotInfo"){
      cin >>otherEnergy>>otherTeamMate;
    }
    else if (str=="Collision"){
      colliding=true;
      cin >>collidingObject>>collidingAngle;
    }
    else if (str=="Energy"){
      cin >>energy;
      Action();
    }

    else{
      //cerr <<str<<endl;
    }
  }
}

int rotatingToLeft=3; /// 1 left, -1 right
int accelerating=-1;
int shooting=-1;

char msg[20][128]={ "Print Muere maldito Amerricano!",
		    "Tu mama hacia el amor con mi perrrito",
		    "Peleas como una vaca (tm)",
		    "Pareces un gamerrrr, maldito!",
		    "Voooodka!",
		    "Por la Sceeene!",
		    "Pareces una golondrina africana llevando cocos!",
		    "Me recuerdas a un Ewok cagando!",
		    "No vales ni para hacer de papa noel (trabajo de un dia, y es mentiraa)!",
		    "Mi sobrina de 3 aos lo hace mejor que tu!",
		    "No hago calculos recursivos que te machaco!",
		    "Pecador!",              
		    "Scene Never Dies!", 
		    "Mejor haz la paz que la guerrra!",
		    "Deja de hacerte gayolas y concentrate!",
		    "Caca, culo, pis! (Huy he dicho palabrostias)",
		    "Hasta el infinito y mas alla!",
		    "Tienes la colita del tamao de una chusta",
		    "Voy ha hacerte el amor mamita...",
		    "Eres mas feo que Cthulhu al levantarse!"
};



void Action(){
  if (radarObject==ROBOT){
    if ((nAttack&7)==0){
      cout <<"Print "<<msg[(10+(nAttack/8))%20]<<endl;
    }
    cout <<"Shoot "<<options[SHOT_MAX_ENERGY]<<endl;
    nAttack++;
  }
  else if (radarObject==MINE);
  else if (radarObject==WALL){
    cout <<"Rotate 6 "<<(options[ROBOT_MAX_ROTATE])*rotatingToLeft<<endl;
  }
  else {
    cout <<"Rotate 6 "<<-(options[ROBOT_MAX_ROTATE]/4.0)*rotatingToLeft<<endl;
    accelerating=10;
  }
  lastRadarDistance=radarDistance;
  lastRadarObject=radarObject;
  fsync(1);
}
