#include <iostream.h>
#include <string.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <time.h>
#include "Messagetypes.h"

//#define DEBUG
#define DEBUG_FILE_NAME "/tmp/epsilum.log"

#ifndef PI
#define PI 3.141592
#endif // PI

#define rad2deg(x) ((x) * 180.0 / PI)
#define deg2rad(x) ((x) * PI / 180.0)

/* See _send_robot_coordinates */
#define ROBOT_COORD_NO                0
#define ROBOT_COORD_RELATIVE_TO_START 1
#define ROBOT_COORD_ABSOLUTE          2

/* Rotations */
#define ROTATE_ROBOT  0x01
#define ROTATE_CANNON 0x02
#define ROTATE_RADAR  0x04
#define ROTATE_ALL    ROTATE_ROBOT | ROTATE_CANNON | ROTATE_RADAR

/* Robot Basic Info */
static char _robot_name[]       = "boty"; //"epsilum robot";
static char _robot_color_home[] = "22AADD";
static char _robot_color_away[] = "FF0000";

/* Game options */
static double _robot_max_rotate;
static double _robot_cannon_max_rotate;
static double _robot_radar_max_rotate;
static double _robot_max_acceleration;
static double _robot_min_acceleration;
static double _robot_start_energy;
static double _robot_max_energy;
static double _robot_energy_levels;
static double _shot_speed;
static double _shot_min_energy;
static double _shot_max_energy;
static double _shot_energy_increase_speed;
static double _timeout;
static double _debug_level;
static int    _send_robot_coordinates;

/* Radar */
static int    _radar_object_type;
static double _radar_distance;
static double _radar_angle;

/* Info */
static double _info_time;
static double _info_speed;
static double _info_cannon_angle;

/* Coord */
static double _coord_x;
static double _coord_y;
static double _coord_angle;

/* Robot Info - Energy of the 'others' robots */
static double _robot_info_energy_level;

/* Robot Rotation Reached */
static int _robot_rotation_reached;

/* Robot Energy Level */
static double _energy_level;
static double _denergy_level; // Variacion de energia

/* Robots left */
static int _robots_left;

/* Collision */
static double _collision_object_type;
static double _collision_angle;

static bool _exit_game    = false;
static bool _game_started = false;

void send_robot_option (int option_number, int value);
void send_robot_name (const char *name);
void send_robot_color (const char *home_color, const char *away_color);
void send_robot_rotate (int what, double angular_velocity);
void send_robot_rotate_to (int what, double angular_velocity, double angle_to_move);
void send_robot_rotate_amount (int what, double angular_velocity, double angle_to_rotate);
void send_robot_sweep (int what, double angular_velocity, double left_angle, double right_angle);
void send_robot_accelerate (double accel);
void send_robot_brake (double brake_percentage);
void send_robot_shoot (double energy);


///////////////////////////////////////////////////////////////////////
//  DEBUG
///////////////////////////////////////////////////////////////////////
#ifdef DEBUG
static FILE *debug_fp;
#endif
void debug_init (void)
{
#ifdef DEBUG
    debug_fp = fopen ("/tmp/epsilum.log", "wt");
    fclose (debug_fp);

    debug_fp = fopen ("/tmp/epsilum.log", "a");
    fprintf (debug_fp, "DEBUG Init\n");
    fclose (debug_fp);
#endif
}

void debug_write (char *msg)
{
#ifdef DEBUG
    debug_fp = fopen ("/tmp/epsilum.log", "a");
    fprintf (debug_fp, "%s\n", msg);
    fclose (debug_fp);
#endif
}

///////////////////////////////////////////////////////////////////////
//   MESSAGES  FROM  ROBOT
///////////////////////////////////////////////////////////////////////
void send_robot_option (int option_number, int value)
{
    cout << "RobotOption " << option_number << " " << value << endl;
}

void send_robot_name (const char *name)
{
    cout << "Name " << name << endl;
}

void send_robot_color (const char *home_color, const char *away_color)
{
    cout << "Colour " << home_color << " " << away_color << endl;
}

void send_robot_rotate (int what, double angular_velocity)
{
    cout << "Rotate " << what << " " << angular_velocity << endl;
}

void send_robot_rotate_to (int what, double angular_velocity, double angle_to_move)
{
    _robot_rotation_reached = 0;
    cout << "RotateTo " << what << " " << angular_velocity << " " << angle_to_move << endl;
}

void send_robot_rotate_amount (int what, double angular_velocity, double angle_to_rotate)
{
    _robot_rotation_reached = 0;
    cout << "RotateAmount " << what << " " << angular_velocity << " " << angle_to_rotate  << endl;
}

// what: cannon or radar
void send_robot_sweep (int what, double angular_velocity, double left_angle, double right_angle)
{
    _robot_rotation_reached = 0;
    cout << "Sweep " << what << " " << angular_velocity << " " << left_angle << " " << right_angle << endl;
}

void send_robot_accelerate (double accel)
{
    cout << "Accelerate " << accel << endl;
}

// brake = {0..1}
void send_robot_brake (double brake_percentage)
{
    cout << "Brake " << brake_percentage << endl;
}

void send_robot_shoot (double energy)
{
    cout << "Shoot " << energy << endl;
}

void send_robot_print (char *text)
{
    cout << "Print " << text << endl;
}

void send_robot_debug (char *text)
{
    cout << "Debug " << text << endl;
}



///////////////////////////////////////////////////////////////////////
//   MESSAGES  TO  ROBOT
///////////////////////////////////////////////////////////////////////
void received_initialize (int is_first_sequence)
{
    if (is_first_sequence)
    {
        send_robot_name  (_robot_name);
        send_robot_color (_robot_color_home, _robot_color_away);
    }
}

void received_game_option (int option, double value)
{
    switch (option)
    {
    case ROBOT_MAX_ROTATE:        _robot_max_rotate        = value; break;
    case ROBOT_CANNON_MAX_ROTATE: _robot_cannon_max_rotate = value; break;
    case ROBOT_RADAR_MAX_ROTATE:  _robot_radar_max_rotate  = value; break;
    case ROBOT_MAX_ACCELERATION:  _robot_max_acceleration  = value; break;
    case ROBOT_MIN_ACCELERATION:  _robot_min_acceleration  = value; break;
    case ROBOT_START_ENERGY:      _robot_start_energy      = value; break;
    case ROBOT_MAX_ENERGY:        _robot_max_energy        = value; break;
    case ROBOT_ENERGY_LEVELS:     _robot_energy_levels     = value; break;
    case SHOT_SPEED:              _shot_speed              = value; break;
    case SHOT_MIN_ENERGY:         _shot_min_energy         = value; break;
    case SHOT_MAX_ENERGY:         _shot_max_energy         = value; break;
    case SHOT_ENERGY_INCREASE_SPEED: _shot_energy_increase_speed = value; break;
    case TIMEOUT:                 _timeout                = value; break;
    case DEBUG_LEVEL:             _debug_level            = value; break;
    case SEND_ROBOT_COORDINATES:  _send_robot_coordinates = (int) value; break;
    default:
        send_robot_print ("Unknown game option!!");
        break;
    }
}

void received_game_starts (void)
{
    _radar_object_type     = NOOBJECT;
    _collision_object_type = NOOBJECT;
    _energy_level          = 100000;
    _robot_rotation_reached = 1;

    _game_started = true;
}

void received_radar (double distance, int object_type, double radar_angle)
{
    /*
    char object_name[32];
    switch (object_type)
    {
    case NOOBJECT: strcpy (object_name, "No Object"); break;
    case ROBOT:    strcpy (object_name, "Robot");     break;
    case SHOT:     strcpy (object_name, "Shot");      break;
    case WALL:     strcpy (object_name, "Wall");      break;
    case COOKIE:   strcpy (object_name, "Cookie");    break;
    case MINE:     strcpy (object_name, "Mine");      break;
    case LAST_OBJECT_TYPE: strcpy (object_name, "Last object"); break;
    default: strcpy (object_name, "Unknown object"); break;
    }

    char msg[128];
    sprintf (msg, "Radar: I found >%s< at %f distance and %f radar angle",
            object_name, distance, radar_angle);
    send_robot_print (msg);
*/
    _radar_object_type = object_type;
    _radar_distance    = distance;
    _radar_angle       = radar_angle;
}

void received_info (double time, double speed, double cannon_angle)
{
    /*
    char msg[128];
    sprintf (msg, "time: %f, speed: %f, cannon_angle: %f",
             time, speed, cannon_angle);
    send_robot_print (msg);
*/
    _info_time         = time;
    _info_speed        = speed;
    _info_cannon_angle = cannon_angle;
}

void received_coordinates (double x, double y, double angle)
{
    _coord_x     = x;
    _coord_y     = y;
    _coord_angle = angle;
}

void received_robot_info (double energy_level, int teammate)
{
    _robot_info_energy_level = energy_level;
}

void received_robot_rotation_reached (int what_has_reached)
{
    _robot_rotation_reached = what_has_reached;
}

void received_energy (double energy_level)
{
    _denergy_level = energy_level - _energy_level;

    _energy_level = energy_level;
}

void received_robots_left (int num_robots)
{
    _robots_left = num_robots;
}

void received_collision (int object_type, double angle)
{
    _collision_object_type = object_type;
    _collision_angle       = angle;
/*
    switch (object_type)
    {
    case NOOBJECT:
        send_robot_print ("Collision: No Object!");
        break;
    case ROBOT:
        send_robot_print ("Collision: Robot!");
        break;
    case SHOT:
        send_robot_print ("Collision: Ups... SHOT!");
        break;
    case WALL:
        send_robot_print ("Collision: Wall!");
        break;
    case COOKIE:
        send_robot_print ("Collision: Ummm COOKIE!");
        break;
    case MINE:
        send_robot_print ("Collision: Uppps MINE!");
        break;
    case LAST_OBJECT_TYPE:
        send_robot_print ("Collision: Last object!");
        break;
        }
        */
}

void received_warning (int warning_type, char *warning_string)
{
    char msg[128];
    sprintf (msg, "Warning[%i]:: %s", warning_type, warning_string);
    send_robot_print (msg);
}

void received_dead (void)
{
    _game_started = false;
}

void received_game_finishes (void)
{
    char msg[] = "Se acabo! jugamos otra?? X-DD";
    send_robot_print (msg);
    _game_started = false;
}

void received_exit_robot (void)
{
    char msg[] = "Vale, vale!!! me piro....";
    send_robot_print (msg);
    _exit_game = true;
    _game_started = false;
}

message_to_robot_type message_name_to_robot_type (char *msg_name)
{
    for (int i=0; message_to_robot[i].msg[0] != '\0'; i++)
    {
        if (strcmp (message_to_robot[i].msg, msg_name) == 0)
            return (message_to_robot_type)i;
    }

    return UNKNOWN_MESSAGE_TO_ROBOT;
}


void check_messages (void)
{
    char msg_name[128];
    message_to_robot_type msg;

    // Reads message from rtb
    cin.clear();
    while ((!cin.eof()) && (!_exit_game))
    {

    cin >> msg_name;
    msg = message_name_to_robot_type (msg_name);

#ifdef DEBUG
    char tmp[256];
    sprintf (tmp, "message: %s", msg_name);
    debug_write (tmp);
#endif

    switch (msg)
    {
    case INITIALIZE:
        int is_first_sequence;
        cin >> is_first_sequence;
        received_initialize (is_first_sequence);
        break;

    case GAME_OPTION:
        int    num_option;
        double value;
        cin >> num_option >> value;
        received_game_option (num_option, value);
        break;

    case GAME_STARTS:
        received_game_starts ( );
        break;

    case RADAR:
        double distance, radar_angle;
        int    object_type;
        cin >> distance >> object_type >> radar_angle;
        received_radar (distance, object_type, radar_angle);
        break;

    case INFO:
        double time, speed, cannon_angle;
        cin >> time >> speed >> cannon_angle;
        received_info (time, speed, cannon_angle);
        break;

    case COORDINATES:
        double coord_x, coord_y, angle;
        cin >> coord_x >> coord_y >> angle;
        received_coordinates (coord_x, coord_y, angle);
        break;

    case ROBOT_INFO:
        double energy_level;
        int    teammate;
        cin >> energy_level >> teammate;
        received_robot_info (energy_level, teammate);
        break;

    case ROTATION_REACHED:
        int what_has_reached;
        cin >> what_has_reached;
        received_robot_rotation_reached (what_has_reached);
        break;

    case ENERGY:
        //double energy_level;
        cin >> energy_level;
        received_energy (energy_level);
        break;

    case ROBOTS_LEFT:
        int num_robots;
        cin >> num_robots;
        received_robots_left (num_robots);
        break;

    case COLLISION:
        //int    object_type;
        //double angle;
        cin >> object_type >> angle;
        received_collision (object_type, angle);
        break;

    case WARNING:
        int  warning_type;
        char warning_string[81];
        cin >> warning_type;
        cin.getline (warning_string, 80, '\n');
        received_warning (warning_type, warning_string);
        break;

    case DEAD:
        received_dead ( );
        break;

    case GAME_FINISHES:
        received_game_finishes ( );
        break;

    case EXIT_ROBOT:
        received_exit_robot ( );
        break;

    default:
        // Unknown message!
        break;
    }
    }
}


// Signal handler! Check messages...
void handle_signal (int sig_number)
{
    check_messages ( );

    // Call this function next time too
    if (signal (sig_number, handle_signal) == SIG_ERR)
    {
        cerr << "Can't init signal USR1" << endl;
        exit (1);
    }
}


///////////////////////////////////////////////////////////////////////
//   MAIN
///////////////////////////////////////////////////////////////////////
int main (int argc, char **argv)
{
    debug_init ( );

    // Configure robot to use signals
    send_robot_option (USE_NON_BLOCKING, true);
    send_robot_option (SIGNAL, SIGUSR1);
    send_robot_option (SEND_ROTATION_REACHED, 1);
    send_robot_option (SEND_SIGNAL, true);

    // Init signal USR1 to function handler 'handle_signal'
    if (signal (SIGUSR1, handle_signal) == SIG_ERR)
    {
        cerr << "Can't init signal USR1" << endl;
        return 1;
    }

    // Libpthread seems to block USR1 sometimes for some reason
    sigset_t usr1set;
    sigemptyset (&usr1set);
    sigaddset (&usr1set, SIGUSR1);
    sigprocmask (SIG_UNBLOCK, &usr1set, NULL);

    while (!_game_started)
    {
        continue;
    }

    double angle = _robot_max_rotate;
    bool   has_viewed_robot = false;
    bool   has_viewed_cookie = false;

    double t1, t2, t3, t4;
    t1 = t2 = t3 = 0;

    double actual_accel = 0.0;
    double actual_angle = 0.0;
    double actual_brake = 0.0;

    send_robot_rotate (ROTATE_ALL, _robot_max_rotate);

    // Main loop
    while (1) //!_exit_game)
    {
        if (_radar_object_type == ROBOT)
        {
            send_robot_rotate (ROTATE_ALL, _radar_angle / 2.0);
            send_robot_brake (1.0);
            //send_robot_accelerate (0.0);

            //char buf[256];
            //sprintf (buf, "Found robot: dist=%3.2f, angle=%3.2f",
            //         _radar_distance,
            //         _radar_angle);
            //send_robot_print (buf);

            send_robot_accelerate (_robot_max_acceleration);

            if (_radar_distance < 6.0)
            {
                send_robot_accelerate (_robot_max_acceleration / 1.5);
                send_robot_shoot (_shot_min_energy + (_shot_max_energy - _shot_min_energy) / 2.0);
            }
            else if (_radar_distance < 4.0)
            {
                //send_robot_brake (0.5);
                send_robot_accelerate (_robot_max_acceleration / 2.5);
                send_robot_shoot (_shot_max_energy);
            }
            else
            {
                send_robot_shoot (_shot_min_energy);
            }

            has_viewed_robot = true;
            //angle            = deg2rad (4.0);
            angle            = -_radar_distance; // - negativo??;

            t2 = _info_time;
        }
        else if (_radar_object_type == MINE)
        {
            send_robot_shoot (_shot_min_energy);
            send_robot_brake (0.0);
            send_robot_rotate (ROTATE_ALL, deg2rad (15.0));
            send_robot_accelerate (_robot_max_acceleration);
        }
        else
        {
/*
            if (has_viewed_cookie && ((_info_time - t4) < 2.0))
            {
                // No Rot
                angle = 0;
            }

            else
*/
            if (has_viewed_robot && ((_info_time - t2) > 0.4))
            {
                angle = -angle;
                has_viewed_robot = false;
                //send_robot_print ("Cambio de giro!");
            }
            else if (has_viewed_robot && ((_info_time - t2) < 0.2))
            {
                send_robot_shoot (_shot_min_energy);
            }

            send_robot_rotate (ROTATE_ALL, angle);

            if ((_info_time - t1) > 1.0)
            {
                angle += deg2rad (6);
                t1 = _info_time;
            }
        }

        /*
        if (_collision_object_type == COOKIE)
        {
            send_robot_brake (0.0);
            send_robot_accelerate (_robot_min_acceleration);
            has_viewed_cookie = false;
        }*/

        /*
        if (_radar_object_type == ROBOT)
        {
            send_robot_print ("Robot!!!");
            send_robot_brake (0.9);
            send_robot_accelerate (_robot_min_acceleration);
            //send_robot_rotate (ROTATE_ALL, 0.0);
            //send_robot_rotate_to (ROTATE_ALL, 0.0, 0.0);
            //send_robot_rotate_amount (ROTATE_ALL, 0.0, 0.0);

            send_robot_rotate (ROTATE_ALL, _radar_angle);

            if ((_radar_distance > 5.0) && ((_info_time - t1) > 0.1))
            {
                send_robot_shoot (_shot_min_energy);
                t1 = _info_time;
            }
            else
                send_robot_shoot (_shot_max_energy);

            //char buf[128];
            //sprintf (buf, "dist = %f", _radar_distance);
            //send_robot_print (buf);
        }
        else if (_radar_object_type == COOKIE)
        {
            send_robot_print ("Cookie");
            send_robot_brake (0.0);
            send_robot_rotate (ROTATE_ROBOT, _radar_angle);
            send_robot_rotate_to (ROTATE_ROBOT, _radar_angle, 10);
            send_robot_rotate_amount (ROTATE_ROBOT, _radar_angle, 10);
            send_robot_accelerate (_robot_max_acceleration);
        }
        else if (_radar_object_type == MINE)
        {
            send_robot_shoot (_shot_min_energy);
        }
        else if (_radar_object_type == SHOT)
        {
            send_robot_accelerate (_robot_max_acceleration);
            send_robot_shoot (_shot_min_energy);
            send_robot_rotate_amount (ROTATE_ROBOT, deg2rad(90), 10.0);
            send_robot_rotate_to (ROTATE_ROBOT, deg2rad(90), 10);
        }
        else
        {
            //send_robot_print ("Sleep");
            // Sleep

            if ((_info_time - t3) > 1.0)
            {
                send_robot_rotate        (ROTATE_RADAR, deg2rad (30.0));
                send_robot_rotate_to     (ROTATE_RADAR, deg2rad (20.0), deg2rad (55.0));
                send_robot_rotate_amount (ROTATE_RADAR, deg2rad (20.0), deg2rad (35.0));
                send_robot_accelerate (_robot_max_acceleration/2.0);
                t3 = _info_time;
            }
        }
*/
        sleep (1);
    }

    return 0;
}
