#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream.h>
#include <unistd.h>
#include <signal.h>
#include <stdlib.h>

#ifdef TIME_WITH_SYS_TIME 
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#include <math.h>
#include "Messagetypes.h"




#define abs(x) ((x>0) ? (x) : -(x))
#define diff 0.5

volatile double acceleration = 0.0;
volatile double robot_rotate = 0.0;
volatile double cannon_rotate = 0.0, radar_rotate = 0.0;
double tid, speed, radar_angle, cannon_angle, tid0, slumprotate = 1.0 ;
double maxspeed = 10.0; 
int robots_left = 20;
bool sweep = false, align_cro= true, align_cra = true, enemy = false;
double angulo, direccion, localizado=0, tlocalizado=0, llocalizado=0;

volatile sig_atomic_t exit_robot = false;


message_to_robot_type
name2msg_to_robot_type(char* msg_name)
{
  for(int i=0; message_to_robot[i].msg[0] != '\0'; i++)
    {
      if( strcmp(message_to_robot[i].msg, msg_name) == 0 )
        return (message_to_robot_type)i;
    }
  return UNKNOWN_MESSAGE_TO_ROBOT;
}

void
check_messages(int sig)
{
  exit_robot = false;

  char msg_name[81];
  char text[81];
  message_to_robot_type msg_t;

  timeval current_time;
  gettimeofday(&current_time, NULL);
  srand(current_time.tv_usec);

  cin.clear();
  while( !cin.eof() )
    {
      cin >> msg_name;
      msg_t = name2msg_to_robot_type(msg_name);
      switch(msg_t)
        {
        case INITIALIZE:
          int init;
          cin >> init ;
          if (init == 1)
            {
              cout << "Name baruba" << endl;
              cout << "Colour F9FF00 F3FA05" << endl;
            }
          break;

	case YOUR_NAME:
	  cout << "Name baru" << endl;
	  break;

	case YOUR_COLOUR:
	  cout << "Colour F9FF00 F3FA05" << endl;
	  break;
	  
/*
{
  UNKNOWN_MESSAGE_FROM_ROBOT = -1,
  ROBOT_OPTION,
  NAME,
  COLOUR,
  //  LOAD_DATA,
  ROTATE,
  ROTATE_TO,
  ROTATE_AMOUNT,
  SWEEP,
  ACCELERATE,
  BRAKE,
  BREAK,
  SHOOT,
  PRINT,
  DEBUG,
  DEBUG_LINE,
  DEBUG_CIRCLE

  //  BIN_DATA_FROM,
  //  ASCII_DATA_FROM,
  //  SAVE_DATA_FINISHED
};
*/


/*        case GAME_STARTS:
          //          cout << "Rotate 1 " << robot_rotate << endl;
          cout << "Sweep 6 " << M_PI/2.0 << " " << -M_PI/2.0 << " " << M_PI/2.0 << endl;
          acceleration = 0.4;
          cout << "Accelerate " << acceleration << endl;
          break;*/
        case GAME_FINISHES:
          break;

        case GAME_OPTION:
          break;

        case GAME_STARTS:
//	  cout << "Sweep 6 " << M_PI_2 << " " << -M_PI_2 << " " << M_PI_2 << endl;
	  cout << "Rotate 1 5" << endl;
          break;


/*

static const struct Message message_to_robot[25] = 
{
  {"Initialize", 1, {INT,    NONE,   NONE,   NONE}},   // arg: if 1 this is the first sequence for the robot, send name and colour!!
  {"YourName",   1, {STRING, NONE,   NONE,   NONE}},   // arg: previous name, send new name only if you don't like it
  {"YourColour", 1, {HEX,    NONE,   NONE,   NONE}},   // arg: previous colour
  {"GameOption", 2, {INT,    DOUBLE, NONE,   NONE}},   // arg 1: OPTION_NR,  arg 2:  value 
  {"GameStarts", 0, {NONE,   NONE,   NONE,   NONE}},
  {"Radar",      3, {DOUBLE, INT,    DOUBLE, NONE}},   // first arg: distance, second arg: object_type, third arg: radar_angle
  {"Info",       3, {DOUBLE, DOUBLE, DOUBLE, NONE}},   // first arg: time, second arg: speed, third arg: cannon_angle
  {"Coordinates",3, {DOUBLE, DOUBLE, DOUBLE, NONE}},   // first arg: x, second arg: y, third arg: angle
  {"RobotInfo",  2, {DOUBLE, INT,    NONE,   NONE}},   // first arg: Other robots energylevel, second arg: enemy - 0, teammate - 1
  {"RotationReached",1,{INT, NONE,  NONE,   NONE}},    // first arg: what has finished rotation (see Rotate below)
  {"Energy",     1, {DOUBLE, NONE,   NONE,   NONE}},   // arg: energylevel
  {"RobotsLeft", 1, {INT,    NONE,   NONE,   NONE}},   // arg: robots left
  {"Collision",  2, {INT,    DOUBLE, NONE,   NONE}},   // first arg: object_type, second arg: collision angle
  {"Warning",    2, {INT,    STRING, NONE,   NONE}},   // first arg: warning_type, second arg: string
  {"Dead",       0, {NONE,   NONE,   NONE,   NONE}},   // Robot died  
  {"GameFinishes",0,{NONE,   NONE,   NONE,   NONE}},
  {"ExitRobot",  0, {NONE,   NONE,   NONE,   NONE}},

  {"",           0, {}}
};

static const struct Message message_from_robot[25] = 
{
  {"RobotOption",  2, {INT, INT}},        // arg 1: OPTION_NR,  arg 2:  value 
  {"Name",         1, {STRING}},             // arg: name
  {"Colour",       2, {HEX, HEX}},           // first arg: home colour, second arg: away colour
  {"Rotate",       2, {INT, DOUBLE}},     // first arg: what to rotate: 1 Robot, 2 cannon, 4 radar and apropriate sums for combinations                                                             // second arg: angular velocity (rad/s)
  {"RotateTo",     3, {INT, DOUBLE, DOUBLE}},     // first and second arg: as in 'Rotate', third arg: angle to move to
  {"RotateAmount", 3, {INT, DOUBLE, DOUBLE}},     // first and second arg: as in 'Rotate', third arg: angle to rotate
  {"Sweep",        4, {INT, DOUBLE, DOUBLE, DOUBLE}}, // first and second arg: as in 'Rotate', but only cannon and radar
                                                      // third arg: left_angle, fourth arg: right_angle  (relative robot)
  {"Accelerate", 1, {DOUBLE}},             // arg: accelerate (m/s^2)  
  {"Brake",        1, {DOUBLE}},             // arg: brake precentage, 0 = no brake, 1 = full brake 
  {"Break",        1, {DOUBLE}},             // Wrong spelling, included for compabillity reasons.
  {"Shoot",        1, {DOUBLE}},             // arg: amount of energy
  {"Print",        1, {STRING}},             // arg: message to print   
  {"Debug",        1, {STRING}},             // arg: debug message
  {"DebugLine",    4, {DOUBLE, DOUBLE, DOUBLE, DOUBLE}}, // arg1,2: startpoint angle, radius (relative robot)
                                                         // arg3,4: endpoint angle, radius (relative robot)
  {"DebugCircle",  3, {DOUBLE, DOUBLE, DOUBLE}},         // arg1,2: centerpoint angle, radius (relative robot)
                                                         // arg3: circle radius
  {"",             0, {}}
};


*/


        case RADAR:
          {
            double dist, energy;
            int object;

            cin >> dist >> object >> radar_angle;
            switch(object)
              {
              case ROBOT:
		localizado=1;
                cout << "Shoot 1" << endl;
 	        cout << "Sweep 4 " << M_PI << " " << -M_PI/(dist*2+1) << " " << M_PI/(dist*2+1) << endl;
                cout << "RotateAmount 1 " << 5 << " " << radar_angle << endl;
		if (radar_angle >= 0) direccion=1;
		else direccion=2;
		angulo+=radar_angle;
//		cout << "Print direccion = " << direccion << endl;
//		cout << "Print DISTANCIA = " << dist << endl;
                cout << "Shoot 3" << endl;
                cout << "Shoot 3" << endl;
                break;
	       case SHOOT:
	        cout << "Shoot 1" << endl ;
		break;
	       case COOKIE:
	        cout << "Shoot 1" << endl;
		
              }
          break;
          }


        case INFO:
          {
            double time, speed, angle;

            cin >> time >> speed >> angle;
	    if (localizado==1) {tlocalizado = time; llocalizado = time + diff; localizado=0;}
	    if (time > llocalizado && localizado==1) {localizado=0;}
//	    cout << "Print TIEMPO / SPEED / ANGLE = " << time << " - " << speed << " - " << angle << endl;
//	    cout << "Print ANGULO = " << angulo << endl;
          break;
          }

        case COORDINATES:
          break;

        case ROTATION_REACHED:
          break;

        case ENERGY:
          break;

        case ROBOTS_LEFT:
		  cout << "Rotate 1 5" << endl;
          break;

        case COLLISION:
          break;

        case WARNING:
          break;

        case DEAD:
          break;

        case ROBOT_INFO:
          break;

/*        case INFO:
          cin >> tid >> speed  >> cannon_angle;
          if(rand() < (RAND_MAX/500))
            {
              slumprotate = 0.0;
              while (abs(slumprotate)<0.5)
                slumprotate = ((double)(rand())/(double)RAND_MAX-0.5)*2.0;
              // cout << "Print seek_and_destroy: slumptal = " << slumprotate << endl;
            }
          break;
          
        case ROBOTS_LEFT:
          cin >> robots_left;
          break;

        case RADAR:
          {
            double dist, energy;
            int object;

            cin >> dist >> object >> radar_angle;
            switch(object)
              {
              case ROBOT:
                enemy = true;
                energy = 20.0/(dist*dist+0.2)+0.5+2.0/double(robots_left);
                robot_rotate = M_PI/3.0;
                if (dist<3.0)
                  {
                    acceleration = 2.0;
                  }
                else
                  {
                    if (speed<maxspeed)
                      acceleration = 2.0;
                    else
                      acceleration = 0.0;
                  }
                cout << "RotateAmount 1 " << robot_rotate << " " << radar_angle << endl;
                cout << "RotateTo 6 " << -robot_rotate << " " << 0.0 << endl;
                cout << "Shoot " << energy << endl;
                cout << "Accelerate " << acceleration << endl;

                //cout << "Print kill" << endl;
                break;
              case WALL:
                {
                  if (enemy)
                    {
                      cout << "Sweep 6 " << M_PI/2.0 << " " << -M_PI/6.0 << " " << M_PI/6.0 << endl;
                      enemy = false;
                      slumprotate = -slumprotate;
                    }
                  if( dist < 1.0 )
                    {
                      cout << "Sweep 6 " << M_PI/2.0 << " " << -M_PI/2.0 << " " << M_PI/2.0 << endl;
                      if (speed > 0.1)
                        {
                          acceleration = 0.0;
                          robot_rotate = 0.0;
                          cout << "Brake 1" << endl;
                        }
                      else
                        {
                          robot_rotate = 5.0*slumprotate;
                          acceleration = 0.1;
                        }
                    }
                  else
                    {
                      if (dist<4.0)
                        {
                          if (speed > 2.0)
                            {
                              acceleration = 0.0 ;
                              robot_rotate = 2.0*slumprotate ;
                              cout << "Brake 0.7" << endl;
                            }
                          else
                            {
                              acceleration = 0.1;
                              robot_rotate = 1.0*slumprotate;
                            }
                        }
                      else
                        {
                          robot_rotate = 0.3*slumprotate;
                          if (speed<maxspeed)
                            acceleration = 2.0;
                          else
                            acceleration = 0.0;
                        }
                        
                    }
                    cout << "Rotate 1 " << robot_rotate << endl;
                    cout << "Accelerate " << acceleration << endl;
                    
                }
                break;
              case SHOT:
                if (speed < 1.0)
                  {
                    acceleration = 2.0;
                    robot_rotate = 1.0*slumprotate;
                  }
                else
                  robot_rotate = 3.0*slumprotate;
                cout << "Accelerate " << acceleration << endl;
                cout << "Rotate 1 " << robot_rotate << endl;
                //cout << "Print Help me!" << endl;
                //                cout << "Print A shot is approaching!" << endl;
                break;
              case COOKIE:
                robot_rotate = 0.0;
                if (speed<3.0)
                  acceleration = 2.0;
                else
                  acceleration = 0.0;
                cout << "Rotate 1 " << robot_rotate << endl;
                cout << "Accelerate " << acceleration << endl;
                
                //                cout << "Print Yummy! A cookie" << endl;
                break;

              case MINE:
                if (dist < 10)
                  {
                    acceleration = 0.0;
                    robot_rotate = 2.0*slumprotate;
                    if (speed > 0.4)
                      cout << "Brake 1" << endl;
                    cout << "Shoot 0.5" << endl;
                    cout << "Accelerate " << acceleration << endl;
                    cout << "Rotate 1 " << robot_rotate << endl;
                  }
                //cout << "Print Avoid this mine" << endl;
                break;
              }
          break;
          }

        case COLLISION:
          {
            int tmp;
            double energy_diff = 0, coll_angle;
            cin >> tmp >> coll_angle;
            switch(tmp)
              {
              case ROBOT: 
                if (abs(coll_angle)<M_PI/6.0 && energy_diff<5)
                  acceleration = 2.0;
                else
                  {
                    acceleration = -0.5;
                    robot_rotate = 5.0*slumprotate;
                  }
                cout << "Accelerate " << acceleration << endl; 
                cout << "Rotate 1 " << robot_rotate << endl;
                break;
              case SHOT:
                if (abs(coll_angle)<M_PI/4.0)
                  {
                    if(speed<3.0)
                      acceleration = 2.0;
                    else
                      acceleration = 0.0;
                    robot_rotate = 5.0*slumprotate;
                  }
                cout << "Rotate 1 " << robot_rotate << endl;
                cout << "Accelerate " << acceleration << endl; 
                break;
              case MINE: 
                cout << "Print Oh no! A mine!" << endl; 
                break;
              case COOKIE: 
                cout << "Print Cookie eaten!" << endl; 
                break;
              case WALL:
                acceleration = 0.0;
                cout << "Accelerate " << acceleration << endl; 
                break;
              }
            //if( enegry_diff != 0 ) cout << "Print energy changed by " << enegry_diff << endl;
          }
          break;
        case WARNING:
          cin.getline(text,80,'\n');
          cout << "Print Help, I got a yellow card!  " << text << endl;
          break;*/
        case EXIT_ROBOT:
          cout << "Print ByeZzZzz" << endl;
          exit_robot = true;
          break;
        default:
          break;
        }
    }
  signal (sig, check_messages);
}

int 
main(int argc, char * argv[])
{
  sigset_t usr1set;

  //robot_rotate = 0.53;


  //check_messages(SIGUSR1);
  signal(SIGUSR1, check_messages);

  // libpthread seems to block USR1 sometimes for some reason
  sigemptyset(&usr1set);
  sigaddset(&usr1set, SIGUSR1);
  sigprocmask(SIG_UNBLOCK, &usr1set, NULL);
  

  cout << "RobotOption " << (int)SIGNAL << " " << (int)SIGUSR1 << endl;

  for(;;sleep(1))
    {
      if( exit_robot ) 
        {
          //          cerr << "Fire: Exiting normally!" << endl;
          return(EXIT_SUCCESS);
        }
    }
  return(EXIT_SUCCESS);
}
