#include "robot.hpp"
#include "consts.hpp"
#include <string>
#include <cstdlib>

const
	std::string
	robot_name =
	"ActiveZ";
const int
	color_1 =
	0xffff00;
const int
	color_2 =
	0xfff444;

class
	ActivezRobot:
	public
	rtb::Robot
{
	struct
	{
		int
			disparoCantidad;
		double
			distance;
		rtb::Consts::object_type
			object;
		double
			radar_angle;
		double
			time;
		double
			speed;
		double
			cannon_angle;
		double
			energy;
		int
			teammate;

	}
	info;

	int
		potencia,
		disparoCantidad;
	bool
		hayGalleta;
	bool hayRadar;
	bool parar;
	double azar;
	bool saliendoDeCurva;
	void
	actua ();
	
	void tratarEscaneoRadar (double distance, rtb::Consts::object_type object,double radar_angle);
	void tratarPared (double distance, rtb::Consts::object_type object,double radar_angle);
	void tratarGalleta (double distance, rtb::Consts::object_type object);
	void aceleracion (double distance, rtb::Consts::object_type object,double radar_angle);
	void tratarDisparo (double distance, rtb::Consts::object_type object,double radar_angle);

	public:
	ActivezRobot (std::string name, int colour, int away_colour);
	virtual ~
	ActivezRobot ()
	{
	}
	void
	GameStarts ();
	void
	Radar (double distance, rtb::Consts::object_type object,
	       double radar_angle);
	void
	Info (double time, double speed, double cannon_angle);
	void
	Collision (rtb::Consts::object_type object, double angle);
	void
	RobotInfo (double energy, int teammate);

};

ActivezRobot::ActivezRobot (std::string name, int colour, int away_colour):
Robot::Robot (name, colour, away_colour)
{
}

void
ActivezRobot::GameStarts ()
{

	Accelerate (0.2);
	Sweep (rtb::Consts::ROTATE_RADAR, 1000, -1.0, 1.0);

}

double
abs (double n)
{
	return n < 0 ? -n : n;
}

void ActivezRobot::tratarEscaneoRadar (double distance, rtb::Consts::object_type object,double radar_angle)
{
	double dform,dmin;
	dmin=4.0;
	if (distance< dmin)
	{
		dform=(distance/dmin)*1.0;
		if(!hayRadar)
		{
				Sweep (rtb::Consts::ROTATE_RADAR, 20, -dform, dform);
				hayRadar=true;
		}
		else
		{
			    Sweep (rtb::Consts::ROTATE_RADAR, 40, -1.0, 1.0);
				hayRadar=false;
		}
	}
}
void ActivezRobot::tratarPared (double distance, rtb::Consts::object_type object,double radar_angle)
{
	double formula;

	if(distance> 3.0)
	{
		formula=(1/(distance*distance));
		saliendoDeCurva=false;
		if(parar)
			Accelerate(0.0);
		else
			Accelerate(1-formula);
		Brake(formula);
		
		
	}
	else if (object == rtb::Consts::IS_MINE || object == rtb::Consts::IS_ROBOT)
	{
		Accelerate(0.0);
		Brake(1.0);
		saliendoDeCurva=false;
	}
	else
	{
		RotateAmount (rtb::Consts::ROTATE_ROBOT, 10, 2 );	
		saliendoDeCurva=true;
		//distance++ ?
		Accelerate(0.0);
		Brake(1.0);
	}						
								
}
void ActivezRobot::tratarGalleta (double distance, rtb::Consts::object_type object)
{
	
		double distmin=5.0;
		if(distance< distmin)
		{
			if(parar)
			{
				Accelerate(0.0);
				Brake(1.0);
			}
			else
			{
				Accelerate(1.0);
				Brake(0.0);
				
			}
		}
		else
		{
			Accelerate((distance/distmin)*1);
			Brake(1-(distance/distmin)*1);
		}
		
}

void ActivezRobot::aceleracion (double distance, rtb::Consts::object_type object,
	     double radar_angle)
{
	if (object == rtb::Consts::IS_MINE || object == rtb::Consts::IS_WALL
	    || object == rtb::Consts::IS_ROBOT)
	{
		tratarPared (distance, object,radar_angle);
		hayGalleta = false;
	}
	else if (object == rtb::Consts::IS_COOKIE and distance < 5.0)
	{
		hayGalleta = true;
		tratarGalleta (distance, object);
	}

}
void
ActivezRobot::tratarDisparo (double distance, rtb::Consts::object_type object,
	       double radar_angle)
{
	
		if (object == rtb::Consts::IS_MINE)
		{
			RotateAmount (rtb::Consts::ROTATE_ROBOT, 6, radar_angle );
			Shoot(1.0);
		}
		else if(object == rtb::Consts::IS_ROBOT)
		{
			RotateAmount (rtb::Consts::ROTATE_ROBOT, 6, radar_angle );
			Shoot(3.0+potencia);
		}
	}

void
ActivezRobot::Radar (double distance, rtb::Consts::object_type object,
		     double radar_angle)
{
	info.distance = distance;
	info.object = object;
	info.radar_angle = radar_angle;
	if (abs (radar_angle) < 0.1)
	{
		tratarEscaneoRadar (distance, object, radar_angle);
		aceleracion (distance, object, radar_angle);
		tratarDisparo (distance, object, radar_angle);

		if (object == rtb::Consts::IS_ROBOT)
		{
		    
			/*if (1-(distance/10)*5 > 1)
					potencia=potencia+ (1-(distance/10))*10;
			else
			     	potencia=potencia+ 1;
			*/
			if (distance <= 1)
				potencia = 100;

			else if (distance <= 2)
				potencia = 5;
			else if (distance <= 3)
				potencia = 3;
			else if (distance <= 5)
				potencia = 2;
			else
				potencia = 1;

			disparoCantidad = 7 + (20 - (int) distance);
			Sweep (rtb::Consts::ROTATE_RADAR, 1000,-0.5 / potencia, 0.5 / potencia);
			RotateAmount (rtb::Consts::ROTATE_ROBOT, 2.0,
				      radar_angle);
			Shoot (potencia);


		}
		else if (object == rtb::Consts::IS_MINE)
		{
			potencia = 1;
			disparoCantidad = (1 - (int) (distance / 20)) * 5;
			Shoot (potencia);
		}
		else if (object == rtb::Consts::IS_SHOT)
		{
			potencia = 1;
			disparoCantidad = 0;
			Shoot (potencia);

		}
		else
		{
			potencia = 2;
			disparoCantidad = 0;
		}


	}
	else
	{
		if (object == rtb::Consts::IS_MINE)
		{
			if (distance < 1.0)
			{
				RotateAmount (rtb::Consts::ROTATE_ROBOT, 8,
					      radar_angle);
				Accelerate (-0.5);
				Brake (1.0);
			}
		}

		if (object == rtb::Consts::IS_ROBOT)
		{
			if (distance < 1.0)
			{
				RotateAmount (rtb::Consts::ROTATE_ROBOT, 10,
					      radar_angle);
				Shoot (100);
				Accelerate (-0.5);
				Brake (1.0);
			}
			else
			{
				RotateAmount (rtb::Consts::ROTATE_ROBOT, 10,
					      radar_angle);
				Accelerate (0.5);
				Brake (0.0);
			}
		}
		if (object == rtb::Consts::IS_COOKIE)
		{
			if (distance < 5.0)
			{
				RotateAmount (rtb::Consts::ROTATE_ROBOT, 10,
					      radar_angle);
				Accelerate (1);
				Brake (0.0);
			}

		}

	}
}

void
ActivezRobot::Info (double time, double speed, double cannon_angle)
{
	info.time = time;
	info.speed = speed;
	info.cannon_angle = cannon_angle;
	if (!hayGalleta)
	{
		parar=(speed>=2.5)?true:false;
	}
	else
	{
		parar=(speed>=3.5)?true:false;
	}
		
	// if (info.object != rtb::Consts::IS_ROBOT) {
	//   actua ();
	// }
}

void
ActivezRobot::Collision (rtb::Consts::object_type object, double angle)
{
	//if (object == rtb::Consts::IS_SHOT) {
	//  if ((angle < -0.5) || (angle > 0.5)) {
	//    Print ("Ouch!");
	//    Accelerate (1000);
	//  }
	//}
	double signo, rota;
	if (object == rtb::Consts::IS_SHOT)
	{
		if (angle >= 0)
			signo = -6.30;
		else
			signo = 6.30;
		Print ("Au! me has dao! ");
		if (abs (angle) > 3.15)
			rota = signo + angle;
		else
			rota = angle;
		if (abs (rota) > 1.0)
			//Aqui meter lo de la curva
			if(!saliendoDeCurva)
				RotateAmount (rtb::Consts::ROTATE_ROBOT, 7, rota);
	}


}

void
ActivezRobot::RobotInfo (double energy, int teammate)
{
	info.energy = energy;
	info.teammate = teammate;

//  if (!info.teammate) {
//    actua ();
//  }
}

void
ActivezRobot::actua ()
{
/*  if (refract)
    refract--;
  switch (info.object) {
  case rtb::Consts::IS_ROBOT:
    RotateAmount (rtb::Consts::ROTATE_ROBOT, 1000, info.radar_angle);
    if (info.distance <= 1)
      Shoot (100);
    else if (info.distance <= 2)
      Shoot (5);
    else if (info.distance <= 3)
      Shoot (3);
    else if (info.distance <= 5)
      Shoot (2);
    else
      Shoot (1);
    Accelerate (0.45);
    break;
  case rtb::Consts::IS_COOKIE:
    RotateAmount (rtb::Consts::ROTATE_ROBOT, 1000, info.radar_angle);
    Accelerate (5);
    break;
  case rtb::Consts::IS_MINE:
    Shoot (0.5);
    break;
  case rtb::Consts::IS_WALL:
    if (info.distance <= 4) {
      Accelerate (-10);
      if ((refract == 0) && (info.radar_angle < 0)) {
	RotateAmount (rtb::Consts::ROTATE_ROBOT, 1000, 3.1416);
	refract = 250;
      } else {
	RotateAmount (rtb::Consts::ROTATE_ROBOT, 1000, -3.1416);
	refract = 250;
      }
      break;
    }
  case rtb::Consts::IS_NOOBJECT:
    Accelerate (((random() % 40) - 10) / 10);
    RotateAmount (rtb::Consts::ROTATE_ROBOT, 1000, ((random() % 40) - 20) / 10);
  }*/
}

int
main (void)
{
	ActivezRobot robot (robot_name, color_1, color_2);

	robot.Scanner ();

	return 0;
}
