// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;

#include "colors.inc"
#include "stones.inc"
#include "woods.inc"
#include "finish.inc"
#include "shapes.inc"
#include "metals.inc"


//#declare Fast=1;
global_settings {
  assumed_gamma 1.0
}
#default{pigment{Green}}


camera
{
  location  <1.3,3.5,1.3>
  direction 1.5*z
  right     x*image_width/image_height
  look_at <0,3.2,.6>
  sky <0,1,-.3>
}

light_source{<1,5,1>*.2,1}

#declare Blade=
difference
{
	sphere{0,1 scale<1,.3,1>}
	sphere{0,.99 scale<1,.3,1>}
	plane{y,0}
	plane{x,.2}
	plane{-x,-.7}
	plane{z,0}
	plane{-z,-.7}
	translate<-.25,0,0>
	rotate<0,0,-20>
}

#declare Ventila=
union
{
difference
{
box
{
	<-1,-1,-100>,<1,1,1>
}

cylinder{<0,0,2>,<0,0,-100>,.9}
cylinder{< .8, .8,2>,< .8, .8,-100>,.1}
cylinder{< .8,-.8,2>,< .8,-.8,-100>,.1}
cylinder{<-.8, .8,2>,<-.8, .8,-100>,.1}
cylinder{<-.8,-.8,2>,<-.8,-.8,-100>,.1}
texture{pigment{Black}finish{Dull}normal{bumps .2 scale .005}}
}
sphere{< .8, .8,.8>,.05 texture{T_Chrome_5A}}
sphere{< .8,-.8,.8>,.05 texture{T_Chrome_5A}}
sphere{<-.8, .8,.8>,.05 texture{T_Chrome_5A}}
sphere{<-.8,-.8,.8>,.05 texture{T_Chrome_5A}}
union
{
object{Blade translate<0,0,.2> rotate<0,0*360/9,0>}
object{Blade translate<0,0,.2> rotate<0,1*360/9,0>}
object{Blade translate<0,0,.2> rotate<0,2*360/9,0>}
object{Blade translate<0,0,.2> rotate<0,3*360/9,0>}
object{Blade translate<0,0,.2> rotate<0,4*360/9,0>}
object{Blade translate<0,0,.2> rotate<0,5*360/9,0>}
object{Blade translate<0,0,.2> rotate<0,6*360/9,0>}
object{Blade translate<0,0,.2> rotate<0,7*360/9,0>}
object{Blade translate<0,0,.2> rotate<0,8*360/9,0>}
cylinder{<0,.3,0>,<0,-.3,0>, .3}
rotate<90,0,0>
translate<0,0,.7>
texture{pigment{Black}finish{Dull}normal{bumps .1 scale .005}}
}
}
/////////////////////////////Roboto
/*union
{
	difference //Pecho
	{
		torus{3,.2 scale <1,.5,1> rotate<0,0,-90>}
		plane{<0,.7, 1>,1.6}
		plane{<0,.7,-1>,1.6}
		plane{<0, 1, 0>,3}
		
	}
	difference	//Peto
	{
		torus{3,.22 scale <1,.5,1> rotate<0,0,-90>}
		plane{<0,.7, 1>,1.68}
		plane{<0,.7,-1>,1.68}
		difference
		{
			plane{<0,-.7, 1>,-1.77}
			plane{-<0,-.7,-1>,1.77}
		}
		plane{<0,1,0>,3}
		pigment{Red}
	}
}

cylinder {<0,2.8,0>,<0,3,0>,.1 scale<1,1,1.4>}

cylinder {<0,2.8,-.14>,<0,2.8,.14>,.1}

*/

union //Banc
{
	box{<-.5,2.8,-300>,<-1.9,2.75,300>}
	cylinder{<-.5,2.775,-300>,<-.5,2.775,300>,.025}
	
	texture{T_Stone15 scale .4}
}
/////////////////////Moble
box 
{
	<-.55,2.8,-300>,<-1.9,0,300>
	texture
	{
		T_Wood34
		rotate<90,0,5>
		scale .3
	}
}
#declare Porta=
union
{
box
{
	<-.52,2.65,-.3>,<-.6,.2,.3>
	texture
	{
		T_Wood34
		rotate<90,0,5>
		scale .3
	}
}
difference
{
box
{
	<-.5,2.65,-4>,<-.6,2.7,4>
	texture
	{
		T_Wood34
		rotate<0,0,5>
		translate 2
		scale .3
	}
}
plane{<0,1,-1>,0 translate<0,2.65,.3>}
plane{<0,1,1>,0 translate<0,2.65,-.3>}
}
difference
{
box
{
	<-.5,2.65,-4>,<-.6,2.6,4>
	texture
	{
		T_Wood34
		rotate<0,0,5>
		translate 2
		scale .3
	}
	translate<0,-2.6,0>
	rotate<90,0,0>
	translate<0,0,.3>
}
plane{-<0,1,-1>,0 translate<0,2.65,.3>}
}
difference
{
box
{
	<-.5,2.55,-4>,<-.6,2.6,4>
	texture
	{
		T_Wood34
		rotate<0,0,5>
		translate 2
		scale .3
	}
	translate<0,-2.6,0>
	rotate<90,0,0>
	translate<0,0,-.3>
}
plane{-<0,1,1>,0 translate<0,2.65,-.3>}
}
torus{.1,.013 texture{T_Gold_1A} scale<.3,1,1> rotate<90,0,0> translate<-.52,2.4,.2>}
}	
object{Porta}
object{Porta scale<1,1,-1> translate<0,0,.73>}
object{Porta scale<1,1,-1> translate<0,0,-.8>}
/////////////////////Final Moble
////////////////////// Parets
plane
{
	z,-2

	texture
	{
		pigment
		{
			checker
				pigment{image_map {png "taulell.png"}},
				pigment{White}
		}
		normal{average normal_map{[3 quilted control0 0 control1 0][1 bozo .3 scale .6]}bump_size .02}
#ifndef(Fast)
		finish{diffuse 0.4 specular 1.0 roughness 0.0001 reflection 0.30}
#end
		scale .16
#ifndef(Fast)
	}
	texture
	{
		pigment{gradient x color_map{[0.008 rgb  1][0.008 rgbf 1][0.992 rgbf 1][0.992 rgb  1]}}
		normal{average normal_map{[3 quilted control0 0 control1 0][1 bozo .3 scale .6]}bump_size .02}
		scale .16
	}
	texture
	{
		pigment{gradient z color_map{[0.008 rgb  1][0.008 rgbf 1][0.992 rgbf 1][0.992 rgb  1]}}
		normal{average normal_map{[3 quilted control0 0 control1 0][1 bozo .3 scale .6]}bump_size .02}
		scale .16
#end
	}
	translate<.35,.245,0>
}

difference
{
plane
{
	x,-1.9
	texture
	{
		pigment
		{
			checker
				pigment{image_map {png "taulell.png"} rotate<0,90,0>},
				pigment{White}
		}
		normal{average normal_map{[3 quilted control0 0 control1 0][1 bozo .3 scale .6]}bump_size .02}
#ifndef(Fast)
		finish{diffuse 0.4 specular 1.0 roughness 0.0001 reflection 0.30}
#end
		scale .16
#ifndef(Fast)
	}
	texture
	{
		pigment{gradient x color_map{[0.008 rgb  1][0.008 rgbf 1][0.992 rgbf 1][0.992 rgb  1]}}
		normal{average normal_map{[3 quilted control0 0 control1 0][1 bozo .3 scale .6]}bump_size .02}
		scale .16
	}
	texture
	{
		pigment{gradient z color_map{[0.008 rgb  1][0.008 rgbf 1][0.992 rgbf 1][0.992 rgb  1]}}
		normal{average normal_map{[3 quilted control0 0 control1 0][1 bozo .3 scale .6]}bump_size .02}
		scale .16
#end
	}
	translate<0,.245,.245>
}
object{box{1,-1} rotate<0,90,0> scale .5 translate<-2.25,3.4,-.5>}
cutaway_textures
}
plane{-(x+z),-3 pigment{image_map{png"fondo.png"}}
}
////////////////////// Final Parets
//////////////////////Calendari

#declare Canto=
lathe {
  bezier_spline
  8, // number of points
  <3,0>,<3, .5>,<2.5,1>,<2  ,1>
  <2,1>,<1,1  >,<2.5,3>,< .5,3>
  scale 1/30
  rotate <90,0,0>
}
union
{
	union
	{
		union
		{
		box{<1,2,.1>,<0,0,0>}
		object{Canto}
		object{Canto translate<1,0,0>}
		object{Canto translate<1,2,0>}
		object{Canto translate<0,2,0>}
		difference
		{
			union
			{
				cylinder{<0,0,0>,<1,0,0>,.1 scale <1,.5,1>}
				cylinder{<0,0,0>,<1,0,0>,.1 scale <1,.5,1> translate<0,2,0>}
				cylinder{<0,0,0>,<0,2,0>,.1 scale <.5,1,1>}
				cylinder{<0,0,0>,<0,2,0>,.1 scale <.5,1,1> translate<1,0,0>}
			}
			plane{z,0}
		}
		texture{T_Wood11 rotate<85,0,0>translate<.5,1,1>}
		}
		union
		{
			sphere{<0,0,0.1>,.02}
			sphere{<1,0,0.1>,.02}
			sphere{<0,2,0.1>,.02}
			sphere{<1,2,0.1>,.02}
			texture{T_Brass_3C}
		}
		translate <-.5,-1,0>
		scale<1.1,1.1,1>
	}
	box
	{
		<1,1,.2>,<0,0,.1>
		pigment{image_map{png"calendar.png"interpolate 2}rotate<0,180,0>}
		translate<-.5,-1,0>
	}
#ifndef (Fast)
	parametric
	{
		function {u},
		function {v},
		function {pow(sin(pow((v-1),3)*4.5),2)*pow((v-1),2)*pow(u-1,6)}
		<0,0>, <1,1>
		accuracy 0.005
		precompute 15 x,y,z
		scale<1,1,.2>
		pigment{image_map{png"calendar.png"interpolate 2 }rotate<0,180,0>}
		translate<-.5,-1,.20000001>
	}
	difference
	{
		parametric
		{
			function {u},
			function {v},
			function {sin(pow((1-v),2)*2.73)*.7}
			<0,0>, <1,1>
			accuracy 0.005
			precompute 15 x,y,z
			scale<1,1,.3>
			pigment{image_map{png"forest.png"interpolate 2 }rotate<0,180,0>}
			translate<-.5,0,.10000001>
		}
	}
#end
	union
	{
		cylinder{<0,.95,0>,<0,.95,.2>,.01}
		cylinder{<0,.95,.2>,<0,1,.2>,.01}
		sphere{<0,.95,.2>,.01}
		texture{T_Chrome_3C}
	}
	scale .3
	translate<-1.1,3.2,-1.9>
}
//////////////////Final Calendari

//////////////////// Encimera
union
{
	box
	{
		<.5,0,.5>,<-.5,.03,-.5>
		texture
		{
			image_pattern{png "XP.png"}
			texture_map
			{
				[0  pigment{rgb <.9,.3,.1>}normal{leopard 5 scale .003}]
				[1  pigment{rgb<1,1,0>}finish{ambient 0.25 brilliance 4 diffuse 0.5 metallic specular 0.80	roughness 1/80 reflection 0.5}normal{bump_map{png "XP.png" bump_size 0.1}}]
			}
			rotate<90,0,0>
			translate<.5,0,.5>
		}
	}
	union
	{
		cylinder{< .35,0, .35>< .35,0.04, .35>,.06}
		cylinder{<-.35,0, .35><-.35,0.04, .35>,.06}
		cylinder{< .35,0,-.35>< .35,0.04,-.35>,.06}
		cylinder{<-.35,0,-.35><-.35,0.04,-.35>,.06}
		texture
		{
			pigment{Black}
			finish{Dull}
		}
		
	}
	
	box
	{
		<.13,0,.13>,<-.13,.04,-.13>
		texture
		{
			image_pattern{png "core.png"}
			texture_map
			{
				[0  pigment{Black}finish{Glossy}]
				[1  pigment{rgb<1,1,1>}finish{brilliance 1 diffuse 1.5 specular 0.80}]
			}
			rotate<90,0,0>
			translate<.5,0,.5>
			scale .26
		}
	}
	
	union
	{
		cylinder{< .5,.02, .5>,< .5,.02,-.5>,.02}
		cylinder{< .5,.02,-.5>,<-.5,.02,-.5>,.02}
		cylinder{<-.5,.02,-.5>,<-.5,.02, .5>,.02}
		cylinder{<-.5,.02, .5>,< .5,.02, .5>,.02}
		
		difference
		{
			union
			{
				cylinder{< .7,-.02, .5>,< .7,-.02,-.5>,.06}
				cylinder{< .7,-.02,-.5>,<-.5,-.02,-.5>,.06}
				cylinder{<-.5,-.02,-.5>,<-.5,-.02, .5>,.06}
				cylinder{<-.5,-.02, .5>,< .7,-.02, .5>,.06}
				sphere{< .7,-.02, .5>,.06}
				sphere{<-.5,-.02, .5>,.06}
				sphere{< .7,-.02,-.5>,.06}
				sphere{<-.5,-.02,-.5>,.06}
	
				difference
				{
					box
					{
						<.5,.04,-.5>,<.7,0,.5>
						texture
						{
							image_pattern{png "encimera.png" use_alpha}
							texture_map
							{
								[0  pigment{image_map{png "encimera.png"}}]
								[1  T_Chrome_2A]
							}
							rotate<90,0,0>
							scale<.2,1,1>
							translate<.5,0,-.5>
						}
					}
					box{<.52,.02,.015>,<.68,.05,0> translate<0,0, .36 >}
					box{<.52,.02,.015>,<.68,.05,0> translate<0,0, .155>}
					box{<.52,.02,.015>,<.68,.05,0> translate<0,0,-.05 >}
				}
				sphere{0,.03 scale<.4,1,1> translate<.52,.03,.015>translate<.10,0, .36 >pigment{Black}}
				sphere{0,.03 scale<.4,1,1> translate<.52,.03,.015>translate<.02,0, .155>pigment{Black}}
				sphere{0,.03 scale<.4,1,1> translate<.52,.03,.015>translate<.02,0,-.05 >pigment{Black}}
			}
			box{.5,-.5}
			plane{y,0}
		}
		texture{T_Chrome_2A}
	}
	rotate<0,270,0>
	translate<-1.1,2.8,-.5>
}
//////////////////// Final Encimera
#declare Xeringa=
union
{
cylinder{<-1,0,0>,<1,0,0>,.3
	texture
	{
		image_pattern{png "arctic.png" interpolate 2 map_type 2}
		texture_map
		{
			[0  pigment{rgb 0}]
			[1  T_Silver_2C]
		}
		rotate<0,0,90>
		scale 2
		translate<1,0,0>

	}
}
sphere{<1.7,0,0>,.09 texture{T_Silver_2C}}
sphere{<1.7,-.03,0>,.09 texture{T_Silver_2C}}

union
{
	cylinder{<-1,0,0>,<-1.1,0,0>,.35 scale<1,1,1.5> pigment{White}}
	cone{<1,0,0>,.3,<1.2,0,0>,0 pigment{White}}
	cylinder{<1.7,0,0>,<1,0,0>,.07 pigment{White}}
	box{<-1,.03,.25>,<-2,-.03,-.25>}
	box{<-1,.03,.25>,<-2,-.03,-.25> rotate<90,0,0>}
	cylinder{<-2,0,0>,<-2.07,0,0>,.35 }
	pigment{White}
}
}
object
{
Xeringa
rotate<0,0,90>
rotate<0,200,0>
scale .25
translate <-1.3,3.3,-1.5>
}
////////////////////////////Ventilador

object{Ventila rotate<0,90,0> scale .5 translate<-2.25,3.4,-.5>}
////////////////////////////Final Ventilador

//////////////////////////Penjador
union
{
box{<.02,.05,1>,<-.02,-.05,-1>}
cylinder{<.04,0, .95>,<-1,0, .95>,.03 pigment{Black}}
cylinder{<.04,0,-.95>,<-1,0,-.95>,.03 pigment{Black}}
union
{
sphere{<0,.1,0>,.04}
difference
{
cylinder{<0,.1,0>,<0,-1.3,0>,.04}
sphere{<0,-1.3,0>, .2 translate<.2,0,0>}
}
difference
{
	sphere{<0,-1.3,0>, .2}
	sphere{<0,-1.3,0>, .199}
	plane{-x-y,0 translate<0,-1.3,0>}
	translate<.2,0,0>
}
rotate<0,0,-3>
translate<0,0,-.7>
}
	
union
{
sphere{<0,.1,0>,.04}
difference
{
cylinder{<0,.1,0>,<0,-1.3,0>,.04}
sphere{<0,0,0>, .2 scale<1.5,1,.8> rotate<0,0,-45> translate<0,-1.3,0>translate<.2,0,0>}
}
difference
{
	sphere{<0,0,0>, .2 scale<1.5,1,.8> rotate<0,0,-45> translate<0,-1.3,0>}
	sphere{<0,0,0>, .199 scale<1.5,1,.8> rotate<0,0,-45> translate<0,-1.3,0>}
	plane{-x-y,0 translate<0,-1.3,0>}
	translate<.2,0,0>
}
rotate<0,0,-5>
translate<0,0,.5>
}
texture{T_Chrome_3B}
scale .3
translate<-1.8,3.5,-1.5>
}	
//////////////////////////Final Penjador


//////////////////Llibres
union
{
box{<.5,.2,.7>,<-.5,0,-.7> texture{pigment{rgb <1,1,.8>}finish {specular 0.0 roughness 0.15}}}
box{
	<.5,.2001,.7>,<-.5,.2,-.7>
	pigment
	{
		image_map
		{
			jpeg "opengl.jpg"
			interpolate 2
		}
		rotate<90,0,0>
		translate .5
		scale<1,1,1.4>
	}
}
scale .3
rotate<0,-58,0>
translate <-.7,2.8,1.1>
}

union
{
box{<1,0,.7>,<0,-.15,-.7>
	pigment{image_map{jpeg"knuth2.jpg"interpolate 2} rotate<90,180,0>translate <0,0,.5>scale<1,1,1.4>}

}
box{
	<1,-.0,.7>,<-.0,.1,-.7>
	rotate<0,0,150>
}
parametric
{
	function {u},
	function {v},
	function {sin(pow((1-v),2)*3.05)*.7}
	<0,0>, <1,1>
	accuracy 0.0001
	precompute 15 x,y,z
	scale<1,1,.3>
	pigment{image_map{jpeg"knuth1.jpg"interpolate 2 }rotate<0,0,0> rotate<0,0,-90>}
	rotate<0,90,0>
	translate<-.03,0,.5>
	scale<1,1,1.4>
	rotate<0,0,59>
}
texture{pigment{rgb <1,1,1>}finish {specular 0.0 roughness 0.15}}
translate <0,.15,0>
scale .3
rotate<0,88,0>
translate <-.9,2.8,.82>

}


//////////Armari
union
{
difference
{
box{<.5,.5,0>,<-.5,.45,.5>}
plane{y-x,0 translate<.5,.5,0>}
texture
{
	T_Wood34
	rotate<0,90,5>
	translate <1,0,1>
	scale .3
	}
}
difference
{
box{<.5,-.5,0>,<-.5,-.45,.5>}
plane{-y-x,0 translate<.5,-.5,0>}
texture
{
	T_Wood34
	rotate<0,90,5>
	translate <1,0,1>
	scale .3
	}
}

difference
{
box{<.5,.5,0>,<.45,-.5,.5>}
plane{x-y,0 translate<.5,.5,0>}
plane{y+x,0 translate<.5,-.5,0>}
texture
{
	T_Wood34
	rotate<0,90,5>
	translate <1,0,1>
	rotate<0,0,90>
	scale .3
	}
}
difference
{
box
{
	<.45,.45,.48>,<-.5,-.45,.30>
	texture
	{
	T_Wood34
	rotate<0,90,5>
	scale .3
	}
}
cylinder{<.3,0,.5>,<.3,0,.45>,.04 texture{T_Gold_1A}}
}
torus{.05,.01 rotate<90,0,0> translate <.3,0,.48> texture{T_Gold_1A}}
rotate<0,90,0>
scale .8
translate<-1.8,3.7,1>
}

//////////////////////BATIDORA

difference
{
sphere_sweep {
  cubic_spline    
  7,          
  <0, 5, 0>, .7
  <0, 4, 0>, .7
  <0, 1, 0>, .7
  <0, -2, 0>, .3
  <0, -3, 0>, .3
  <0, -4, 0>, .8
  <0, -5, 0>, .8
}
plane{y,-4}
box{<.3,-3.7,5>,<-.3,-3.9,-5>rotate<0,0*360/3,0>}
box{<.3,-3.7,5>,<-.3,-3.9,-5>rotate<0,1*360/3,0>}
box{<.3,-3.7,5>,<-.3,-3.9,-5>rotate<0,2*360/3,0>}
sphere{<0,-4,0>,.7}
pigment
{
	image_map
	{
		png "T&L.png"
		interpolate 2
		map_type 2
	}
	scale 9
	translate<0,4,0>
	rotate <0,120,0>
}
scale .07
rotate 80
translate<-1.7,3.09,.53>
}

union
{
isosurface {
  function { f_helix1(x,y,z, 1, 2, .1, .5, .3, 3,1)}          // function (can also contain declared functions
  contained_by { box { -1.2, 1.2 } }
  accuracy 0.001 
  max_gradient 4 
  texture{pigment{rgb <6,0,0>}finish{ambient 1}}
  rotate<0,0*360/6,0>
}

isosurface {
  function { f_helix1(x,y,z, 1, 2, .3, .5, .3, 3,1)}          // function (can also contain declared functions
  contained_by { box { -1.2, 1.2 } }
  accuracy 0.001 
  max_gradient 4 
  texture{pigment{rgb <0,6,0>}finish{ambient 1}}
  rotate<0,1*360/6,0>
}
isosurface {
  function { f_helix1(x,y,z, 1, 2, .3, .5, .3, 3,1)}          // function (can also contain declared functions
  contained_by { box { -1.2, 1.2 } }
  accuracy 0.001 
  max_gradient 4 
  texture{pigment{rgb <0,0,6>}finish{ambient 1}}
  rotate<0,2*360/6,0>
}
isosurface {
  function { f_helix1(x,y,z, 1, 2, .3, .5, .3, 3,1)}          // function (can also contain declared functions
  contained_by { box { -1.2, 1.2 } }
  accuracy 0.001 
  max_gradient 4 
  texture{pigment{rgb <0,6,6>}finish{ambient 1}}
  rotate<0,3*360/6,0>
}
isosurface {
  function { f_helix1(x,y,z, 1, 2, .3, .5, .3, 3,1)}          // function (can also contain declared functions
  contained_by { box { -1.2, 1.2 } }
  accuracy 0.001 
  max_gradient 4 
  texture{pigment{rgb <6,0,6>}finish{ambient 1}}
  rotate<0,3*360/6,0>
}
isosurface {
  function { f_helix1(x,y,z, 1, 2, .3, .5, .3, 3,1)}          // function (can also contain declared functions
  contained_by { box { -1.2, 1.2 } }
  accuracy 0.001 
  max_gradient 4 
  texture{pigment{rgb <6,6,0>}finish{ambient 1}}
  rotate<0,3*360/6,0>
}
scale .6
translate <-1.2,3.3,-.6>
}


global_settings {
  radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.02           // end pretrace at this size
    count 200                      // higher -> higher quality (1..1600) [35]
    nearest_count 5               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 2                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    //normal on                   // take surface normals into account [off]
    //media on                    // take media into account [off]
    save_file "rad"       // save radiosity data
    //load_file "file_name"       // load saved radiosity data
    //always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples
  }
}
