#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
#include "ptc\tinyptc.h"



#define u8  unsigned char
#define s8  char
#define u16 unsigned short int
#define s16 short int
#define u32 unsigned int
#define s32 int


#define XSIZE 320
#define YSIZE 240
#define SIZE XSIZE*YSIZE
   
#define RGB32(r,g,b) ((r << 16) | (g << 8)  | (b))


void lee_raw (u8 *buffer, s8 *nombre)
{
	FILE *fp;

	fp = fopen (nombre, "rb");

	if (fp == NULL)
	{
		MessageBox (NULL, "Impossible leer!", "Error", MB_OK);
	}
	
	fread (buffer, 95*30*3, 1, fp);

	fclose (fp);
}

void putpixel (u32 *buffer, u32 x, u32 y, u32 color)
{
	buffer[x + y *320] = color;
}

void blit_raw_letras (u32 *dst, u8 *src, u32 x, u32 y)
{
	u32 i = 0;

	for (u32 v = 0; v < 30; v++)
	{
		for (u32 u = 0; u < 95; u++)
		{	
			u32 pos = u + x + (v*320) + (y*320);

			if (pos > 0 && pos < SIZE)
			{
				if (src[i] != 0 || src[i+1] != 0 || src[i+2] != 0)
				{
				
					//dst [ pos ] = RGB32 (	src [i+0], 
											//src [i+1], 
											//src [i+2] );

					dst [pos] = 0xbfbfbf;
				}
			}

			i+=3;
		}
	}
}


void adrawquad (u32 *buffer, s32 x1, s32 y1, u32 mida, u32 color)
{
	for (u32 x = x1; x <= x1+mida; x++)
	{
		for (u32 y = y1; y <= y1+mida; y++)
		{
			u32 pos = x + y * 320;

			if (pos > 0 && pos < SIZE)
			{
				if (buffer[x + y*320] + color < 0xffffff)
				{
					buffer[x + y*320] += color;
				}
				else
				{
					buffer[x + y * 320] = 0xffffff;
				}
			}
		}		
	}
}

void blur (u32 *buffer)
{

	for (u32 x = 0; x < XSIZE; x++)
	{
		for (u32 y = 0; y < YSIZE-1; y++)
		{
			u32 pos = x + y *320;

			u32 r = buffer [pos-320] & 0xff0000;
			u32 g = buffer [pos-320] & 0x00ff00;
			u32 b = buffer [pos-320] & 0x0000ff;

			if (buffer[pos-320] == 0xbfbfbf)
			{
				buffer[pos] = 0;
				continue;
			}

			r += buffer [pos+320] & 0xff0000;
			g += buffer [pos+320] & 0x00ff00;
			b += buffer [pos+320] & 0x0000ff;

			if (buffer[pos+320] == 0xbfbfbf)
			{
				buffer[pos] = 0;
				continue;
			}

			r += buffer [pos+1] & 0xff0000;
			g += buffer [pos+1] & 0x00ff00;
			b += buffer [pos+1] & 0x0000ff;


			if (buffer[pos+1] == 0xbfbfbf)
			{
				buffer[pos] = 0;

				continue;
			}

			r += buffer [pos-1] & 0xff0000;
			g += buffer [pos-1] & 0x00ff00;
			b += buffer [pos-1] & 0x0000ff;

			if (buffer[pos-1] == 0xbfbfbf)
			{
				buffer[pos] = 0;


				continue;
			}

			r = (r >> 2) & 0xff0000;
			g = (g >> 2) & 0xff00;
			b = (b >> 2) & 0xff;
/*
			if (r > 0x020000) { r -= 0x020000; }
			if (g > 0x0200) { g -= 0x0200; }
			if (b > 0x02) { b -= 0x02; }

*/
			buffer [pos] = r | g | b;
			
		}
	}
}


void drawquad (u32 *buffer, u32 x1, u32 x2, u32 y1, u32 y2, u32 color)
{
	for (u32 x = x1; x <= x2; x++)
	{
		putpixel (buffer, x, y1, color);
		putpixel (buffer, x, y1+1, color);
		putpixel (buffer, x, y2, color);
		putpixel (buffer, x, y2+1, color);
	}

	for (u32 y = y1; y <= y2; y++)
	{
		putpixel (buffer, x1, y, color);
		putpixel (buffer, x2, y, color);

		putpixel (buffer, x1+1, y, color);
		putpixel (buffer, x2+1, y, color);
	}
}



int main()
{
	u32 *buffer;
	u8 *letras[3];
	u8 color = 0;
	//float frames = 0;
	//int t = GetTickCount ();

	buffer = (u32 *) malloc (SIZE*4);
	letras[0] = (u8*) malloc (95*30*3);
	letras[1] = (u8 *) malloc (95*30*3);
	letras[2] = (u8 *) malloc (95*30*3);


	if (!ptc_open("Fast Code",XSIZE,YSIZE)) 
		return 1;


	lee_raw (letras[0], "l1.raw");
	lee_raw (letras[1], "l2.raw");
	lee_raw (letras[2], "l3.raw");

	//blit_raw_letras (buffer, letras[2], 20, 10);

	u32 lx1 = 7, ly1 = 12;
	u32 lx2 = 7, ly2 = 12+70;
	u32 lx3 = 7, ly3 = 12+140;


	s32  x1 = 7,  y1 = 12;
	s32  x2 = 47,  y2 = 22;
	s32  x3 = 57,  y3 = 32;

	s32 ax1 = 1, ay1 = 1;	
	s32 ax2 = 1, ay2 = -1;	
	s32 ax3 = -1, ay3 = 1;

    while (!ESC_pressed)
    {		
		blur (buffer);
		
		drawquad (buffer, 5, 105, 10, 230,   0xbfbfbf);
		drawquad (buffer, 105, 205, 10, 230, 0xbfbfbf);
		drawquad (buffer, 205, 305, 10, 230, 0xbfbfbf);

		blit_raw_letras (buffer, letras[0], lx1+100, ly1);
		blit_raw_letras (buffer, letras[1], lx1+200, ly1);
		blit_raw_letras (buffer, letras[2], lx1,	 ly1);

		blit_raw_letras (buffer, letras[2], lx2+100, ly2);
		blit_raw_letras (buffer, letras[1], lx2+200, ly2);
		blit_raw_letras (buffer, letras[0], lx2,	 ly2);

		blit_raw_letras (buffer, letras[2], lx3+100, ly3);
		blit_raw_letras (buffer, letras[0], lx3+200, ly3);
		blit_raw_letras (buffer, letras[1], lx3,	 ly3);

		adrawquad (buffer, x1, y1, 40, 0x0b);
		adrawquad (buffer, x2, y2, 40, 0x0b00);
		adrawquad (buffer, x3, y3, 40, 0x0b0000);

		ly1++;
		ly2++;
		ly3++;

		y1 += ay1;
		x1 += ax1;
		y2 += ay2;
		x2 += ax2;
		y3 += ay3;
		x3 += ax3;

		if ((x1 + 40) > 320 || x1 < 0)	{	ax1 = -ax1;	}
		if ((y1 + 40) > 240 || y1 < 0)	{	ay1 = -ay1;	}
		if ((x2 + 40) > 320 || x2 < 0)	{	ax2 = -ax2;	}
		if ((y2 + 40) > 240 || y2 < 0)	{	ay2 = -ay2;	}
		if ((x3 + 40) > 320 || x3 < 0)	{	ax3 = -ax3;	}
		if ((y3 + 40) > 240 || y3 < 0)	{	ay3 = -ay3;	}

		

		if (ly1 + 35 > 228) { ly1 = 12; }
		if (ly2 + 35 > 228) { ly2 = 12; }
		if (ly3 + 35 > 228) { ly3 = 12; }

        ptc_update(buffer);
		//frames++;
    }

	//t = GetTickCount() - t;

	//frames = frames / ((float)t/1000.0f);

	//s8 msg[100];

	//sprintf (msg, "%.2f", frames);

	//MessageBox (NULL, msg, "Frames x Sec", MB_OK);

	free (buffer);
    // close ptc
    ptc_close();

    // exit process
    ExitProcess(0);

	return 0;
}


