/*
    Copyright 1999 by Nate 'm|d' Miller
    For non-commercial use only!

    File        -- mathlib.h
    Date        -- 5/29/99
    Author      -- Nate 'm|d' Miller
    Contact     -- vandals1@home.com
    Web         -- http://members.home.com/vandals1
*/
#define PI					3.1415926535897932f
#define PID					(PI / 180.0f)
#define PIM					(PI * 180.0f)
#define degToRad(d)			(float)d * PID
#define radToDeg(r)			((float)r * PI)/180.0f;

#ifndef __MATHLIBDEFS__
#define __MATHLIBDEFS__

#ifndef vec_t
typedef float vec_t;
#endif

#ifndef vec3_t
typedef vec_t vec3_t[3];
#endif

typedef vec_t matrix_t[16];  // a 4x4 matrix

typedef struct
{
	vec3_t v;
	vec_t w;
} quat_t;

#endif

// matrix prototypes
void matrixIdentity (matrix_t p);
void matrixMultiply (matrix_t a, matrix_t b, matrix_t c);
void matrixRotateX (matrix_t p, vec_t angle);
void matrixRotateY (matrix_t p, vec_t angle);
void matrixRotateZ (matrix_t p, vec_t angle);
void matrixRotate (matrix_t m, vec3_t r);
void matrixMultiplyVector (matrix_t m, vec3_t v);
//void matrixMultiplyVector (matrix_t m, vec3_t t, vec3_t d);

// vector prototypes
void vectorClear (vec3_t a);
void vectorCopy (vec3_t a, vec3_t b);
void vectorCrossProduct (vec3_t v1, vec3_t v2, vec3_t cross);
vec_t vectorDot (vec3_t v1, vec3_t v2);
void vectorSubtract (vec3_t va, vec3_t vb, vec3_t out);
void vectorAdd (vec3_t va, vec3_t vb, vec3_t out);
vec_t vectorNormalize (vec3_t in, vec3_t out);
void vectorScaleV (vec3_t a, vec3_t s);
void vectorScale (vec3_t v, vec_t scale);


