#include "extras.h"

void OrthoMode(int left, int top, int right, int bottom)
{
	glMatrixMode(GL_PROJECTION);						

	glPushMatrix();									
	
	glLoadIdentity();								

	//Pass in our 2D ortho screen coordinates like so (left, right, bottom, top).  The last
	// 2 parameters are the near and far planes.
	glOrtho( left, right, bottom, top, 0, 1 );	
	
	glMatrixMode(GL_MODELVIEW);								

	glLoadIdentity();										
}

void PerspectiveMode()		
{
	glMatrixMode( GL_PROJECTION );							

	glPopMatrix();											

	glMatrixMode( GL_MODELVIEW );							
}

void frontPlane()
{
	glPushMatrix();
	glLoadIdentity();
	glBegin(GL_QUADS);
		glVertex3f(-0.05518f, -0.041385f, -0.1f);
		glVertex3f(0.05518f, -0.041385f, -0.1f);
		glVertex3f(0.05518f, 0.041385f, -0.1f);
		glVertex3f(-0.05518f, 0.041385f, -0.1f);
	glEnd();
	glPopMatrix();
}

float flashColor = 0.0f;

void flash(float start, float end, float time, float intes)
{
	int tex = 0, light = 0, blend = 0, depth = 0;

	if ((time >= start) && (time <= end))
	{
		float incr = (intes*2.0f)/(end-start);
		float timePass = time-start;

		if ((flashColor >= 0.0f) && (flashColor < intes))
			flashColor = incr * timePass;
		else flashColor = (intes*2.0f)-(incr * timePass);

		if(glIsEnabled(GL_TEXTURE_2D)){
			glDisable(GL_TEXTURE_2D);
			tex=1;
		}
		if(glIsEnabled(GL_LIGHTING)){
			glDisable(GL_LIGHTING);
			light=1;
		}
		if(!glIsEnabled(GL_LIGHTING)){
			glEnable(GL_BLEND);
			glBlendFunc(GL_DST_ALPHA, GL_ONE);
			blend=1;
		}
		if(glIsEnabled(GL_DEPTH_TEST)){
			glDisable(GL_DEPTH_TEST);
			depth=1;
		}				
		glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);

		glColor4f(flashColor, flashColor, flashColor, 1.0f);
		frontPlane();

		if(depth) glEnable(GL_DEPTH_TEST);
		if(blend) glDisable(GL_BLEND);
		if(light) glEnable(GL_LIGHTING);
		if(tex) glEnable(GL_TEXTURE_2D);
	}

}

float fadeColor;

void fade(int mode, float start, float end, float time)
{
	int tex = 0, light = 0, blend = 0, depth = 0;

	if ((time >= start) && (time <= end))
	{
		float incr = 1.0f/(end-start);
		float timePass = time-start;

		switch (mode)
		{
			case FADE_IN:	//if (fadeColor < 1.0f)
							fadeColor = incr * timePass;
							break;
			case FADE_OUT:	//if (fadeColor > 0.0f)
							fadeColor = 1.0f - (incr * timePass);
							break;
		}
		
		
		if(glIsEnabled(GL_TEXTURE_2D)){
			glDisable(GL_TEXTURE_2D);
			tex=1;
		}
		if(glIsEnabled(GL_LIGHTING)){
			glDisable(GL_LIGHTING);
			light=1;
		}
		if(!glIsEnabled(GL_LIGHTING)){
			glEnable(GL_BLEND);
			glBlendFunc(GL_DST_COLOR, GL_ZERO);
			blend=1;
		}
		if(glIsEnabled(GL_DEPTH_TEST)){
			glDisable(GL_DEPTH_TEST);
			depth=1;
		}
		glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);

		glColor4f(fadeColor, fadeColor, fadeColor, 1.0f);
		frontPlane();
		
		if(depth) glEnable(GL_DEPTH_TEST);
		if(blend) glDisable(GL_BLEND);
		if(light) glEnable(GL_LIGHTING);
		if(tex) glEnable(GL_TEXTURE_2D);
	}

}

void CreateRenderTexture(UINT textureArray[], int size, int channels, int type, int textureID)										
{
	// Create a pointer to store the blank image data
	unsigned int *pTexture = NULL;											

	// We need to create a blank texture to render our dynamic texture too.
	// To do this, we just create an array to hold the data and then give this
	// array to OpenGL.  The texture is stored on the video card so we can
	// destroy the array immediately afterwards.
	// This function takes the texture array to store the texture, the
	// size of the texture for width and the heigth, the channels (1, 3 or 4),
	// the type (LUMINANCE, RGB, RGBA, etc..) and the texture ID to assign it too.

	// Allocate and init memory for the image array and point to it from pTexture
	pTexture = new unsigned int [size * size * channels];
	memset(pTexture, 0, size * size * channels * sizeof(unsigned int));	

	// Register the texture with OpenGL and bind it to the texture ID
	glGenTextures(1, &textureArray[textureID]);								
	glBindTexture(GL_TEXTURE_2D, textureArray[textureID]);					
	
	// Create the texture and store it on the video card
	glTexImage2D(GL_TEXTURE_2D, 0, channels, size, size, 0, type, GL_UNSIGNED_INT, pTexture);						
	
	// Set the texture quality
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);

	// Since we stored the texture space with OpenGL, we can delete the image data
	delete [] pTexture;																					
}

void plane(float x, float y, float z, float width, float height, float uTile, float vTile)
{
	glPushMatrix();

	glTranslatef(x, y, z);

	glBegin(GL_QUADS);
		
		// Create a texture mapped QUAD that has the new texture map on it
		glTexCoord2f(0.0f, 0.0f);			glVertex3f(0, 0,  0);
		glTexCoord2f(   uTile, 0.0f);		glVertex3f( width, 0,  0);
		glTexCoord2f(   uTile,    vTile);	glVertex3f( width,  height,  0); 		
		glTexCoord2f(0.0f,    vTile);		glVertex3f(0,  height,  0);		

	glEnd();

	glPopMatrix();
}

void CreateBox(float x, float y, float z, float width, 
			   float height,  float length, float uscale, float vscale)
{	
	// This centers the box around (x, y, z)
	x = x - width  / 2;
	y = y - height / 2;
	z = z - length / 2;

	// Start drawing the side as a QUAD
	glBegin(GL_QUADS);		
		
		// Assign the texture coordinates and vertices for the BACK Side
		glTexCoord2f(0.0f,     0.0f); glVertex3f(x,			y,			z);
		glTexCoord2f(0.0f,   vscale); glVertex3f(x,			y + height, z);
		glTexCoord2f(uscale, vscale); glVertex3f(x + width, y + height, z); 
		glTexCoord2f(uscale,   0.0f); glVertex3f(x + width, y,			z);
	
		// Assign the texture coordinates and vertices for the FRONT Side
		glTexCoord2f(uscale,   0.0f); glVertex3f(x,			y,			z + length);
		glTexCoord2f(uscale, vscale); glVertex3f(x,			y + height, z + length);
		glTexCoord2f(0.0f,   vscale); glVertex3f(x + width, y + height, z + length); 
		glTexCoord2f(0.0f,     0.0f); glVertex3f(x + width, y,			z + length);
	
		// Assign the texture coordinates and vertices for the BOTTOM Side
		glTexCoord2f(uscale,   0.0f); glVertex3f(x,			y,			z);
		glTexCoord2f(uscale, vscale); glVertex3f(x,			y,			z + length);
		glTexCoord2f(0.0f,   vscale); glVertex3f(x + width, y,			z + length); 
		glTexCoord2f(0.0f,     0.0f); glVertex3f(x + width, y,			z);

		// Assign the texture coordinates and vertices for the TOP Side
		glTexCoord2f(uscale, vscale); glVertex3f(x,			y + height,	z);
		glTexCoord2f(uscale,   0.0f); glVertex3f(x,			y + height,	z + length);
		glTexCoord2f(0.0f,     0.0f); glVertex3f(x + width, y + height, z + length); 
		glTexCoord2f(0.0f,   vscale); glVertex3f(x + width, y + height, z);
	
		// Assign the texture coordinates and vertices for the LEFT Side
		glTexCoord2f(uscale,   0.0f); glVertex3f(x,			y,			z);
		glTexCoord2f(0.0f,     0.0f); glVertex3f(x,			y,			z + length);
		glTexCoord2f(0.0f,   vscale); glVertex3f(x,			y + height,	z + length); 
		glTexCoord2f(uscale, vscale); glVertex3f(x,			y + height,	z);

		// Assign the texture coordinates and vertices for the RIGHT Side
		glTexCoord2f(0.0f,     0.0f); glVertex3f(x + width, y,			z);
		glTexCoord2f(uscale,   0.0f); glVertex3f(x + width, y,			z + length);
		glTexCoord2f(uscale, vscale); glVertex3f(x + width, y + height,	z + length); 
		glTexCoord2f(0.0f,   vscale); glVertex3f(x + width, y + height,	z);

	// Stop drawing quads
	glEnd();
}