#ifndef __CURVES_H__
#define __CURVES_H__

#include "general.h"

typedef vec3_t ctrlPoints[4];

typedef struct
{
	vec3_t	subPoints;			//x, y, z de cada punto interpolado
	float	n1, n2, n3, n4;		//Coeficientes
} interPoint;

typedef struct 
{
	ctrlPoints	ctrPoint;			//Puntos que definen la curva
	int			numPoints;			//Numero de puntos a interpolar
	interPoint	*points;			//Lista de puntos interpolados
} curve_t;




/*   SURFACE


	 V  |^
		|	*   *   *   *
		|	|   |   |   |
		|	*   *   *   *
		|   |   |   |   |
		|	*   *   *   *
		|	|   |   |   |
		|	*   *   *   *
		|____________________>  U
*/

typedef struct
{                      
	ctrlPoints	uCtrPoint[4];		// 16 puntos de control para 4 curvas en U
	int			uPoints, vPoints;
	curve_t		ctrCurves[4];		// Curvas que pasan por los puntos de control en U
	curve_t		*curves;			// Curvas a lo largo de la superficie en V
} surface_t;


/*********/


typedef vec3_t ctrlPoints8[8];

typedef struct
{
	vec3_t	subPoints;			//x, y, z de cada punto interpolado
	float	n1, n2, n3, n4, n5, n6, n7, n8;		//Coeficientes
} interPoint8;

typedef struct
{
	ctrlPoints8	ctrPoint;	//8 puntos de control
	int			numPoints;		//numero de puntos a interpolar
	interPoint8	*points;
}curve8_t;


				//type  -> 1 - Finit interpolation point
				//	    -> 0 - Bezier

int createCurve (ctrlPoints ctrPoint, int points, curve_t *curve, int type);  

int moveCtrlPoints(ctrlPoints newCtrPoint, curve_t *curve);

int createCloseCurve (ctrlPoints8 ctrPoint, int points, curve8_t *curve, int type);

int drawCurve(curve_t curve, int mode);

int drawCurve(curve8_t curve, int mode);

int createSurface(surface_t *surface, int uPoints, int vPoints);

int drawSurface(surface_t *surface, int mode, float uTile, float vTile);

#endif