#include "curve01.h"
#include "general.h"
#include "curves.h"

curve_t cv01;
curve_t cv02;
curve8_t clcv01;

int LoadCurve01()
{
	ctrlPoints cv01ctp = {{2.0f, 0.0f, 0.0f},
					{1.0f, 2.0f, 0.0f},
					{-1.0f, 2.0f, 0.0f},
					{-2.0f, 0.0f, 0.0f}};

	createCurve(cv01ctp, 100, &cv01, 1);

	ctrlPoints cv02ctp = {{-2.0f, 0.0f, 0.0f},
					{-1.0f, -2.0f, 0.0f},
					{1.0f, -2.0f, 0.0f},
					{2.0f, 0.0f, 0.0f}};

	ctrlPoints8 clcv01ctp = {{0.0f, 2.0f, 0.0f},
					{1.0f, 3.0f, 0.0f},
					{2.0f, 4.0f, 0.0f},
					{3.0f, 3.0f, 0.0f},
					{4.0f, 2.0f, 0.0f},
					{3.0f, 2.0f, 0.0f},
					{2.0f, 0.0f, 0.0f},
					{1.0f, 2.0f, 0.0f}
	};

	createCurve(cv02ctp, 100, &cv02, 1);
	createCloseCurve(clcv01ctp, 100, &clcv01, 1);

    return 1;
}

int SetCurve01 ()
{
	BuildFont();

	glEnable(GL_DEPTH_TEST);
	glDisable(GL_TEXTURE_2D);
	
	glMatrixMode(GL_MODELVIEW);

	glClearColor(0.0f, 0.0f, 0.0f, 1.0f);

	return 1;
}

float val = 0.0f;

int DrawCurve01 (float time)
{
if (runStat != STOP){
/*******************DRAW PART*************************************/

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	if (viewTime) printTime(time);
	if (viewFps) printFps(time);

	glLoadIdentity();

	glTranslatef(0.0f, 0.0f, -8.0f);
	glRotatef(60.0f, 1.0f, 1.0f, 0.0f);
	glRotatef(2*val, 0.0f, 0.0f, 1.0f);

	glColor3f(0.0f, 0.0f, 1.0f);
//	drawCurve(cv01, 0);
//	drawCurve(cv02, 0);
	drawCurve(clcv01, 0);
	glColor3f(1.0f, 0.0f, 0.0f);
//	drawCurve(cv01, 1);
//	drawCurve(cv02, 1);
	drawCurve(clcv01, 0);

/*	cv01.ctrPoint[1][1] = sin(val);
	cv01.ctrPoint[2][1] = cos(val);
		
	moveCtrlPoints(cv01.ctrPoint, &cv01);

	cv02.ctrPoint[1][1] = 2*sin(val);
	cv02.ctrPoint[2][1] = 2*cos(val);
		
	moveCtrlPoints(cv02.ctrPoint, &cv02);
*/	
	val += 0.25;

	lastTime = time;

/***************************************************************************/
}//if runStat
	return 1;
}

static void partFree()
{
	
	KillFont();
}

int Curve01()
{
	SetCurve01 ();

	while (!appExit && !done)
	{
		if (!BucleMsg())
		{
			if (active && !DrawCurve01(COUNTER_Get() + timeDisplacement))	// Active?  Was There A Quit Received?
			{
				appExit=TRUE;							// ESC or DrawGLScene Signalled A Quit
			}
			else									// Not Time To Quit, Update Screen
			{
				SwapBuffers(hDC);					// Swap Buffers (Double Buffering)
			}
		}
	}
	
	partFree();

	done = FALSE;

	return 1;
}